/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.Skill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;
import java.util.HashMap;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

@MythicMechanic(author="Ashijin", name="pickupitem", aliases={}, description="Picks up the target item entity")
public class PickUpItemMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    private boolean doFakeLooting;
    protected Optional<Skill> onPickupSkill = Optional.empty();

    public PickUpItemMechanic(SkillExecutor manager, File file, String skill, MythicLineConfig mlc) {
        super(manager, file, skill, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.SYNC_ONLY;
        this.doFakeLooting = mlc.getBoolean(new String[]{"fakelooting", "fl"}, true);
        String strPickupSkill = mlc.getString(new String[]{"onpickup", "pickup", "then"}, null, new String[0]);
        ((MythicBukkit)this.getPlugin()).getSkillManager().queueSecondPass(() -> {
            if (strPickupSkill != null) {
                this.onPickupSkill = ((MythicBukkit)this.getPlugin()).getSkillManager().getSkill(file, this, strPickupSkill);
                if (this.onPickupSkill.isEmpty()) {
                    MythicLogger.errorMechanicConfig(this, mlc, "Could not find MetaSkill " + strPickupSkill);
                }
            }
        });
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        Entity entity = target.getBukkitEntity();
        if (!(entity instanceof Item)) {
            return SkillResult.INVALID_TARGET;
        }
        Item item = (Item)entity;
        AbstractEntity caster = data.getCaster().getEntity();
        ItemStack stack = item.getItemStack();
        if (stack.getType() == Material.AIR) {
            return SkillResult.INVALID_TARGET;
        }
        if (caster.isPlayer()) {
            Player player = (Player)caster.getBukkitEntity();
            if (this.doFakeLooting) {
                int id = ((MythicBukkit)this.getPlugin()).getVolatileCodeHandler().getItemHandler().spawnFakeItem(player, stack, target.getLocation());
                Schedulers.sync().runLater(() -> ((MythicBukkit)this.getPlugin()).getVolatileCodeHandler().getItemHandler().collectFakeItem(player, id), 5L);
            }
            HashMap left = player.getInventory().addItem(new ItemStack[]{stack});
            for (ItemStack entry : left.values()) {
                item.getLocation().getWorld().dropItem(item.getLocation(), entry);
            }
        } else {
            LivingEntity livingEntity = (LivingEntity)caster.getBukkitEntity();
            livingEntity.playPickupItemAnimation(item);
        }
        this.onPickupSkill.ifPresent(skill -> {
            SkillMetadata newData = data.deepClone();
            newData.setOrigin(target.getLocation());
            newData.setLocationTarget(target.getLocation());
            newData.setMetadata("item", stack);
            if (skill.isUsable(newData)) {
                skill.execute(newData);
            }
        });
        item.remove();
        return SkillResult.SUCCESS;
    }
}

