/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;

@MythicMechanic(author="Ashijin", name="setMaxHealth", aliases={"setMaxHp"}, description="Sets the target's max health")
public class SetMaxHealthMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    private PlaceholderDouble amount;
    private Mode mode;

    public SetMaxHealthMechanic(SkillExecutor manager, File file, String line, MythicLineConfig mlc) {
        super(manager, file, line, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.SYNC_ONLY;
        this.amount = mlc.getPlaceholderDouble(new String[]{"amount", "a"}, 1.0, new String[0]);
        String mode = mlc.getString(new String[]{"mode", "m"}, "STATIC", new String[0]);
        try {
            this.mode = Mode.valueOf(mode.toUpperCase());
        }
        catch (Error | Exception ex) {
            this.mode = Mode.STATIC;
            MythicLogger.errorMechanicConfig(this, mlc, "Invalid mode");
        }
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (target.isLiving()) {
            switch (this.mode.ordinal()) {
                case 0: {
                    target.setMaxHealth(this.amount.get(data, target));
                    break;
                }
                case 1: {
                    double newMaxHealth = this.amount.get(data, target);
                    double oldHealth = target.getHealth();
                    double oldMaxHealth = target.getMaxHealth();
                    double percent = oldHealth / oldMaxHealth;
                    double newHealth = newMaxHealth * percent;
                    target.setMaxHealth(newMaxHealth);
                    target.setHealth(newHealth);
                    break;
                }
            }
        }
        return SkillResult.SUCCESS;
    }

    private static enum Mode {
        STATIC,
        SCALE;

    }
}

