/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.projectiles.bullet;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.utils.Events;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.skills.projectiles.Projectile;
import io.lumine.mythic.core.skills.projectiles.ProjectileBullet;
import io.lumine.mythic.core.skills.projectiles.ProjectileBulletType;
import io.lumine.mythic.core.skills.projectiles.ProjectileBulletableTracker;
import io.lumine.mythic.core.utils.annotations.MythicField;
import org.bukkit.Location;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.SpectralArrow;
import org.bukkit.entity.Trident;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.util.Vector;

public class ArrowBullet
extends ProjectileBullet {
    @MythicField(name="arrowType", description="    The type of arrow to use if the bullet type is ARROW\n    Arrow Types:\n    - NORMAL\n    - SPECTRAL\n    - TRIDENT\n", defValue="NORMAL")
    protected ArrowType arrowType;

    public ArrowBullet(ProjectileBulletType type, SkillMechanic projectile, MythicLineConfig config) {
        super(type, projectile, config);
        String strArrowType = config.getString(new String[]{"bulletarrowtype", "arrowtype"}, "NORMAL", new String[0]);
        try {
            this.arrowType = ArrowType.valueOf(strArrowType);
        }
        catch (Throwable ex) {
            MythicLogger.errorMechanicConfig(projectile, config, "Invalid bullet arrow type specified");
        }
    }

    @Override
    public ProjectileBullet.BulletTracker create(ProjectileBulletableTracker projectile, AbstractEntity target) {
        return new ArrowBulletTracker(projectile, target);
    }

    @Override
    public boolean isVirtual() {
        return false;
    }

    protected static enum ArrowType {
        NORMAL,
        SPECTRAL,
        TRIDENT;

    }

    public class ArrowBulletTracker
    extends ProjectileBullet.BulletTracker {
        protected AbstractEntity bullet;

        public ArrowBulletTracker(ProjectileBulletableTracker projectile, AbstractEntity target) {
            super(ArrowBullet.this, projectile, target);
            Events.subscribe(EntityDamageByEntityEvent.class).filter(event -> this.bullet != null).filter(event -> event.getDamager() != null).filter(event -> event.getDamager().getUniqueId().equals(this.bullet.getUniqueId())).handler(event -> event.setCancelled(true)).bindWith(projectile);
        }

        @Override
        public void spawn(AbstractLocation start) {
            Location loc = BukkitAdapter.adapt(start);
            AbstractLocation currentLocation = this.getProjectile().getPreviousLocation();
            AbstractVector currentVelocity = this.getProjectile().getCurrentVelocity();
            Location to = BukkitAdapter.adapt(currentLocation).clone();
            Vector delta = BukkitAdapter.adapt(currentVelocity).normalize().multiply(this.getProjectile().getVelocityMagnitude() / 7.6);
            double yaw = Math.atan2(delta.getX(), delta.getZ());
            float newYaw = (float)Math.toDegrees(-yaw);
            loc.setYaw(newYaw);
            Arrow arrow = switch (ArrowBullet.this.arrowType.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 0 -> (Arrow)loc.getWorld().spawn(loc, Arrow.class);
                case 1 -> (SpectralArrow)loc.getWorld().spawn(loc, SpectralArrow.class);
                case 2 -> (Trident)loc.getWorld().spawn(loc, Trident.class);
            };
            arrow.setPickupStatus(AbstractArrow.PickupStatus.DISALLOWED);
            arrow.setPierceLevel(125);
            arrow.setTicksLived(Integer.MAX_VALUE);
            arrow.setInvulnerable(true);
            arrow.setGravity(false);
            this.bullet = BukkitAdapter.adapt((Entity)arrow);
            this.bullet.setVelocity(this.getProjectile().getCurrentVelocity());
            Projectile.BULLET_ENTITIES.add(this.bullet);
            ArrowBullet.this.getPlugin().getVolatileCodeHandler().getEntityHandler().setHitBox(this.bullet, 0.0, 0.0);
            if (this.getProjectile().hasTerminated()) {
                this.bullet.remove();
            }
        }

        @Override
        public void tick(AbstractLocation origin) {
            AbstractVector o = this.bullet.getLocation().toVector();
            AbstractVector n = this.getProjectile().getCurrentLocation().toVector();
            AbstractVector velocity = n.subtract(o).normalize().multiply(this.getProjectile().getVelocityMagnitude());
            if (velocity.isFinite()) {
                this.bullet.setVelocity(velocity);
            } else {
                this.bullet.setVelocity(this.getProjectile().getCurrentVelocity());
            }
        }

        @Override
        public void despawn() {
            this.bullet.remove();
            Projectile.BULLET_ENTITIES.remove(this.bullet);
        }
    }
}

