/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.targeters;

import com.google.common.collect.Lists;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.targeters.IEntitySelector;
import io.lumine.mythic.core.utils.annotations.MythicTargeter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Predicate;

@MythicTargeter(author="Ashijin", name="entitiesInRadius", aliases={"livingEntitiesInRadius", "livingInRadius", "allInRadius", "EIR"}, description="Targets entities around the caster")
public class EntitiesInRadiusTargeter
extends IEntitySelector {
    protected PlaceholderDouble radius;
    protected Predicate<AbstractEntity> livingOnly;

    public EntitiesInRadiusTargeter(SkillExecutor manager, MythicLineConfig mlc) {
        super(manager, mlc);
        this.radius = PlaceholderDouble.of(mlc.getString(new String[]{"radius", "r"}, "5", new String[0]));
        boolean livingOnly = mlc.getBoolean(new String[]{"livingonly", "living", "l"}, true);
        this.livingOnly = livingOnly ? AbstractEntity::isLiving : ae -> true;
    }

    @Override
    public Collection<AbstractEntity> getEntities(SkillMetadata data) {
        return this.getEntitiesNearPoint(data, this.livingOnly, data.getCaster().getLocation());
    }

    protected Collection<AbstractEntity> getEntitiesNearPoint(SkillMetadata data, AbstractLocation location) {
        return this.getEntitiesNearPoint(data, null, location);
    }

    protected Collection<AbstractEntity> getEntitiesNearPoint(SkillMetadata data, Predicate<AbstractEntity> filter, AbstractLocation location) {
        ArrayList targets = Lists.newArrayList();
        double radiusSq = Math.pow(this.radius.get(data), 2.0);
        Predicate<AbstractEntity> entityFilter = ae -> {
            if (!this.livingOnly.test((AbstractEntity)ae)) {
                return false;
            }
            if (filter == null) {
                return true;
            }
            return filter.test((AbstractEntity)ae);
        };
        for (AbstractEntity p : location.getWorld().getEntitiesNearLocation(location, this.radius.get(data), entityFilter)) {
            if (p.getUniqueId().equals(data.getCaster().getEntity().getUniqueId()) || !(this.distanceSquared(location, p) < radiusSq)) continue;
            targets.add(p);
        }
        if (this.targetSelf) {
            targets.add(data.getCaster().getEntity());
        }
        return targets;
    }
}

