/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.targeters;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.targeters.IEntitySelector;
import io.lumine.mythic.core.utils.MythicUtil;
import io.lumine.mythic.core.utils.annotations.MythicTargeter;
import java.util.Collection;
import java.util.HashSet;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

@MythicTargeter(author="Ashijin", name="target", aliases={"T"}, description="Targets the caster's target")
public class TargetTargeter
extends IEntitySelector {
    public TargetTargeter(SkillExecutor manager, MythicLineConfig mlc) {
        super(manager, mlc);
    }

    @Override
    public Collection<AbstractEntity> getEntities(SkillMetadata data) {
        LivingEntity le;
        HashSet<AbstractEntity> targets = new HashSet<AbstractEntity>();
        SkillCaster caster = data.getCaster();
        if (caster instanceof ActiveMob) {
            ActiveMob am = (ActiveMob)caster;
            if (am.hasThreatTable()) {
                targets.add(am.getThreatTable().getTopThreatHolder());
            } else {
                targets.add(am.getEntity().getTarget());
            }
        } else if (caster.getEntity().isPlayer() && (le = MythicUtil.getTargetedEntity((Player)BukkitAdapter.adapt(caster.getEntity()))) != null) {
            targets.add(BukkitAdapter.adapt((Entity)le));
        }
        return targets;
    }
}

