/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.variables;

import io.lumine.mythic.core.skills.variables.Variable;
import io.lumine.mythic.core.skills.variables.VariableType;
import io.lumine.mythic.core.skills.variables.types.AbstractVariable;
import io.lumine.mythic.core.skills.variables.types.DoubleVariable;
import io.lumine.mythic.core.skills.variables.types.FloatVariable;
import io.lumine.mythic.core.skills.variables.types.IntegerVariable;
import io.lumine.mythic.core.skills.variables.types.LocationVariable;
import io.lumine.mythic.core.skills.variables.types.StringVariable;
import io.lumine.mythic.core.skills.variables.types.VectorVariable;

public class VariableUtils {
    public static VariableType getType(Class<? extends Variable> clazz) {
        if (clazz.equals(IntegerVariable.class)) {
            return VariableType.INTEGER;
        }
        if (clazz.equals(FloatVariable.class)) {
            return VariableType.FLOAT;
        }
        if (clazz.equals(DoubleVariable.class)) {
            return VariableType.DOUBLE;
        }
        if (clazz.equals(StringVariable.class)) {
            return VariableType.STRING;
        }
        if (clazz.equals(AbstractVariable.class)) {
            return VariableType.ABSTRACT;
        }
        if (clazz.equals(LocationVariable.class)) {
            return VariableType.LOCATION;
        }
        if (clazz.equals(VectorVariable.class)) {
            return VariableType.VECTOR;
        }
        throw new IllegalArgumentException("Invalid variable class (" + clazz.getName() + ").");
    }

    public static String getTypeName(Class<? extends Variable> clazz) {
        if (clazz.equals(IntegerVariable.class)) {
            return "Integer";
        }
        if (clazz.equals(FloatVariable.class)) {
            return "Float";
        }
        if (clazz.equals(DoubleVariable.class)) {
            return "Double";
        }
        if (clazz.equals(StringVariable.class)) {
            return "String";
        }
        if (clazz.equals(AbstractVariable.class)) {
            return "Abstract";
        }
        if (clazz.equals(LocationVariable.class)) {
            return "Location";
        }
        if (clazz.equals(VectorVariable.class)) {
            return "Vector";
        }
        throw new IllegalArgumentException("Invalid variable class (" + clazz.getName() + ").");
    }

    public static Class<? extends Variable> getTypeClass(String type) {
        switch (type) {
            case "Integer": {
                return IntegerVariable.class;
            }
            case "Float": {
                return FloatVariable.class;
            }
            case "Double": {
                return DoubleVariable.class;
            }
            case "String": {
                return StringVariable.class;
            }
            case "Abstract": {
                return AbstractVariable.class;
            }
            case "Location": {
                return LocationVariable.class;
            }
            case "Vector": {
                return VectorVariable.class;
            }
        }
        throw new IllegalArgumentException("Invalid variable type : " + type + ".");
    }
}

