/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.variables.types;

import com.google.common.base.Preconditions;
import io.lumine.mythic.core.skills.variables.Variable;

public class DoubleVariable
extends Variable {
    private double value;

    public DoubleVariable(double value) {
        Preconditions.checkNotNull((Object)value);
        this.value = value;
    }

    public DoubleVariable(double value, long expirationTime) {
        super(expirationTime);
        Preconditions.checkNotNull((Object)value);
        this.value = value;
    }

    @Override
    public Object get() {
        return this.value;
    }

    public String toString() {
        return "" + this.value;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DoubleVariable)) {
            return false;
        }
        DoubleVariable other = (DoubleVariable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Double.compare(this.getValue(), other.getValue()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof DoubleVariable;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $value = Double.doubleToLongBits(this.getValue());
        result = result * 59 + (int)($value >>> 32 ^ $value);
        return result;
    }
}

