/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.variables.types;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.lumine.mythic.core.skills.variables.Variable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class EntityListVariable
extends Variable {
    private final List<UUID> values;

    public EntityListVariable(List<UUID> values) {
        Preconditions.checkNotNull(values);
        this.values = values;
    }

    @Override
    public Object get() {
        return this.values;
    }

    public String toString() {
        return "VAR_EntityList(" + String.valueOf(this.values) + ")";
    }

    @Override
    public Variable clone() {
        ArrayList newList = Lists.newArrayList(this.values);
        return new EntityListVariable(newList);
    }

    public List<UUID> getValues() {
        return this.values;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EntityListVariable)) {
            return false;
        }
        EntityListVariable other = (EntityListVariable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<UUID> this$values = this.getValues();
        List<UUID> other$values = other.getValues();
        return !(this$values == null ? other$values != null : !((Object)this$values).equals(other$values));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EntityListVariable;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<UUID> $values = this.getValues();
        result = result * 59 + ($values == null ? 43 : ((Object)$values).hashCode());
        return result;
    }
}

