/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.variables.types;

import com.google.common.base.Preconditions;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.core.skills.variables.Variable;

public class VectorVariable
extends Variable {
    private AbstractVector value;

    public VectorVariable(AbstractVector value) {
        Preconditions.checkNotNull((Object)value);
        this.value = value;
    }

    public VectorVariable(AbstractVector value, long expirationTime) {
        super(expirationTime);
        Preconditions.checkNotNull((Object)value);
        this.value = value;
    }

    @Override
    public Object get() {
        return this.value;
    }

    public String toString() {
        return this.value.getX() + "," + this.value.getY() + "," + this.value.getZ();
    }

    @Override
    public Variable clone() {
        AbstractVector newVector = new AbstractVector(this.value.getX(), this.value.getY(), this.value.getZ());
        return new VectorVariable(newVector);
    }

    public AbstractVector getValue() {
        return this.value;
    }

    public void setValue(AbstractVector value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VectorVariable)) {
            return false;
        }
        VectorVariable other = (VectorVariable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AbstractVector this$value = this.getValue();
        AbstractVector other$value = other.getValue();
        return !(this$value == null ? other$value != null : !((Object)this$value).equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VectorVariable;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AbstractVector $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        return result;
    }
}

