/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.spawning.random;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.lumine.mythic.api.adapters.AbstractBiome;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractStructure;
import io.lumine.mythic.api.adapters.AbstractWorld;
import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.mobs.MythicMob;
import io.lumine.mythic.api.mobs.entities.SpawnReason;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.collections.WeightedCollection;
import io.lumine.mythic.bukkit.utils.cooldown.Cooldown;
import io.lumine.mythic.bukkit.utils.numbers.Numbers;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.mobs.WorldScaling;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.skills.SkillString;
import io.lumine.mythic.core.skills.conditions.InvalidCondition;
import io.lumine.mythic.core.spawning.random.RandomSpawnMob;
import io.lumine.mythic.core.spawning.random.RandomSpawnPoint;
import io.lumine.mythic.core.spawning.random.RandomSpawnerAction;
import io.lumine.mythic.core.spawning.random.RandomSpawnerManager;
import io.lumine.mythic.core.spawning.random.SpawnPointType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class RandomSpawner {
    public static Set<RandomSpawnPoint> spawnPoints = Collections.newSetFromMap(new ConcurrentHashMap());
    private final MythicBukkit plugin;
    private final RandomSpawnerManager manager;
    private String name;
    private Collection<String> configuredMobTypes = null;
    private WeightedCollection<RandomSpawnMob> mobTypes = new WeightedCollection();
    private RandomSpawnerAction action;
    private int priority;
    private int maxSpawnerMobCount = -1;
    private int maxLocalMobCount = -1;
    private PlaceholderDouble level;
    private float chance;
    private Cooldown cooldown;
    private Collection<String> worldNames = Lists.newArrayList();
    private Collection<String> regionTags = Lists.newArrayList();
    private Collection<AbstractWorld> worlds = Lists.newArrayList();
    private Collection<AbstractBiome> biomes = Sets.newConcurrentHashSet();
    private Collection<AbstractStructure> structures = Sets.newConcurrentHashSet();
    private Collection<CreatureSpawnEvent.SpawnReason> spawnReasons = Lists.newArrayList();
    private List<SkillCondition> conditions;
    private SpawnPointType positionType = SpawnPointType.LAND;
    private boolean hasConditions = false;
    private boolean useWorldScaling = true;

    /*
     * WARNING - void declaration
     */
    public RandomSpawner(RandomSpawnerManager manager, String file, String name, MythicConfig mc) {
        String[] spawn;
        this.plugin = (MythicBukkit)manager.getPlugin();
        this.manager = manager;
        this.name = name;
        String strAction = mc.getString("SpawnMethod", "ADD");
        strAction = mc.getString("Action", strAction);
        this.action = RandomSpawnerAction.valueOf(strAction.toUpperCase());
        if (mc.isList("Types")) {
            List<String> lines = mc.getStringList("Types");
            for (String string : lines) {
                try {
                    Optional<MythicMob> optional;
                    String[] split = string.split(" ");
                    String strMobType = split[0];
                    double weight = 1.0;
                    if (split.length > 1) {
                        weight = Double.valueOf(split[1]);
                    }
                    if (!(optional = this.getPlugin().getMobManager().getMythicMob(strMobType)).isPresent()) continue;
                    spawn = new RandomSpawnMob(optional.get(), weight);
                    this.mobTypes.add((RandomSpawnMob)spawn);
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
            }
        } else {
            String strMobName = mc.getString("Mobname", "");
            strMobName = mc.getString("MobName", strMobName);
            strMobName = mc.getString("MobType", strMobName);
            strMobName = mc.getString("Type", strMobName);
            if (!(strMobName = mc.getString("Types", strMobName)).equalsIgnoreCase("GROUP")) {
                String[] types;
                for (String s2 : types = strMobName.split(",")) {
                    this.getPlugin().getMobManager().getMythicMob(s2).ifPresent(mm4 -> this.mobTypes.add(new RandomSpawnMob((MythicMob)mm4, 1.0)));
                }
            }
        }
        this.level = mc.getPlaceholderDouble("Level", "1");
        this.chance = (float)mc.getDouble("Chance", 1.0);
        this.priority = mc.getInteger("Priority", 1);
        this.maxSpawnerMobCount = mc.getInteger("MaxPerCluster", -1);
        this.maxLocalMobCount = mc.getInteger("MaxLocalMobs", MythicBukkit.inst().getConfiguration().getRandomSpawningLocalLimit());
        this.useWorldScaling = mc.getBoolean("UseWorldScaling", true);
        int cooldown = mc.getInteger("Cooldown", 0);
        if (cooldown > 0) {
            this.cooldown = Cooldown.of(cooldown, TimeUnit.SECONDS);
        }
        String strPositionType = "LAND";
        try {
            strPositionType = mc.getString("PositionType", "LAND");
            this.positionType = SpawnPointType.valueOf(strPositionType.toUpperCase());
        }
        catch (Exception exception) {
            MythicLogger.errorSpawnConfig(this, mc, "'" + strPositionType + "' is not a valid value for PositionType");
            this.positionType = SpawnPointType.LAND;
        }
        List<String> list = mc.getStringList("Conditions");
        for (String s3 : list) {
            SkillCondition sc;
            if (s3.contains("\"")) {
                void var13_33;
                String[] split = s3.split("\"");
                int i = 0;
                String string = "";
                spawn = split;
                int n = spawn.length;
                for (int j = 0; j < n; ++j) {
                    String ss = spawn[j];
                    if (i % 2 == 1) {
                        String string2 = var13_33.concat("\"" + SkillString.unparseMessageSpecialChars(ss) + "\"");
                    } else {
                        String string3 = var13_33.concat(ss);
                    }
                    ++i;
                }
                s3 = var13_33;
            }
            if ((sc = this.getPlugin().getSkillManager().getCondition(s3)) instanceof InvalidCondition) continue;
            if (this.conditions == null) {
                this.conditions = new ArrayList<SkillCondition>();
            }
            this.conditions.add(sc);
        }
        if (this.conditions != null && this.conditions.size() > 0) {
            this.hasConditions = true;
        }
        String world = mc.getString("Worlds");
        String reasons = mc.getString("Reason");
        reasons = mc.getString("Reasons", reasons);
        if (world != null) {
            String[] worldName = world.split(",");
            World w = null;
            if (worldName != null) {
                for (String wName : worldName) {
                    this.worldNames.add(wName);
                    w = Bukkit.getWorld((String)wName);
                    if (w == null) continue;
                    this.worlds.add(BukkitAdapter.adapt(w));
                }
            }
        }
        this.regionTags = mc.getStringList("RegionTags");
        ArrayList biomes = null;
        if (mc.isSet("Biomes")) {
            biomes = mc.isList("Biomes") ? mc.getStringList("Biomes") : Lists.newArrayList((Object[])mc.getString("Biomes").split(","));
        } else if (mc.isSet("Biome")) {
            biomes = Lists.newArrayList((Object[])new String[]{mc.getString("Biome")});
        }
        if (biomes != null) {
            for (String string : biomes) {
                try {
                    Collection<AbstractBiome> maybeBiomes = this.getPlugin().getBootstrap().getBiomes(string);
                    this.biomes.addAll(maybeBiomes);
                }
                catch (Error | Exception ex) {
                    MythicLogger.errorSpawnConfig(this, mc, "Biome '" + string + "' not found");
                    ex.printStackTrace();
                }
            }
        }
        ArrayList lstStructures = Lists.newArrayList();
        if (mc.isList("Structures")) {
            lstStructures.addAll(mc.getStringList("Structures"));
        } else if (mc.isSet("Structure")) {
            lstStructures.add(mc.getString("Structure"));
        }
        for (String structureName : lstStructures) {
            Optional<AbstractStructure> structure = MythicBukkit.inst().getVolatileCodeHandler().getWorldHandler().getStructure(structureName);
            if (!structure.isPresent()) continue;
            this.structures.add(structure.get());
        }
        if (reasons != null) {
            String[] stringArray;
            for (String rr : stringArray = reasons.split(",")) {
                CreatureSpawnEvent.SpawnReason fr = CreatureSpawnEvent.SpawnReason.valueOf((String)rr);
                if (fr == null) continue;
                this.spawnReasons.add(fr);
            }
        }
    }

    public Collection<String> getConfiguredMobTypes() {
        if (this.configuredMobTypes != null) {
            return this.configuredMobTypes;
        }
        this.configuredMobTypes = new ArrayList<String>();
        for (RandomSpawnMob t2 : this.mobTypes.getView()) {
            this.configuredMobTypes.add(t2.getMob().getInternalName());
        }
        return this.configuredMobTypes;
    }

    public float getChance() {
        return this.chance;
    }

    public double getLevel(AbstractLocation location) {
        double level = this.getBaseLevel();
        if (this.useWorldScaling) {
            level += WorldScaling.getLevelBonus(location);
        }
        return level;
    }

    public double getBaseLevel() {
        return this.level.get();
    }

    public Collection<CreatureSpawnEvent.SpawnReason> getReasons() {
        return this.spawnReasons;
    }

    public boolean isValid() {
        return !this.mobTypes.getView().isEmpty();
    }

    public boolean hasConditions() {
        return this.hasConditions;
    }

    public boolean checkSpawn(RandomSpawnPoint rsp) {
        if (this.cooldown != null && !this.cooldown.testSilently()) {
            return false;
        }
        if ((double)this.chance < Numbers.randomDouble()) {
            return false;
        }
        if (this.maxLocalMobCount > 0) {
            double localCap = this.maxLocalMobCount;
            if (rsp.getNearbyPlayers() > 1) {
                double mod = (double)(rsp.getNearbyPlayers() - 1) * MythicBukkit.inst().getConfiguration().getRandomSpawningGroupMultiplier();
                localCap *= mod;
            }
            if ((double)rsp.getLocalMobCount() > localCap) {
                return false;
            }
        }
        if (!this.spawnReasons.isEmpty()) {
            if (!this.spawnReasons.contains(rsp.getReason())) {
                return false;
            }
        } else {
            switch (rsp.getReason()) {
                case NATURAL: {
                    break;
                }
                case REINFORCEMENTS: {
                    break;
                }
                case VILLAGE_INVASION: {
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        if (this.worlds != null && !this.worlds.isEmpty() && !this.worlds.contains(rsp.getLocation().getWorld())) {
            return false;
        }
        if (!this.biomes.isEmpty() && !this.biomes.contains(rsp.getBiome())) {
            return false;
        }
        if (!this.structures.isEmpty()) {
            Collection<AbstractStructure> structures = MythicBukkit.inst().getVolatileCodeHandler().getWorldHandler().getStructures(rsp.getLocation());
            boolean match = false;
            for (AbstractStructure struct : structures) {
                if (!this.structures.contains(struct)) continue;
                match = true;
                break;
            }
            if (!match) {
                return false;
            }
        }
        if (this.hasConditions()) {
            for (SkillCondition condition : this.conditions) {
                if (condition.evaluateRandomSpawnPoint(rsp)) continue;
                return false;
            }
        }
        if (this.cooldown != null) {
            this.cooldown.test();
        }
        return true;
    }

    public ActiveMob spawn(RandomSpawnPoint rsp) {
        if (this.mobTypes.getView().isEmpty()) {
            return null;
        }
        MythicMob mm4 = this.mobTypes.get().getMob();
        return MythicBukkit.inst().getMobManager().spawnMob(mm4.getInternalName(), rsp.getLocation(), SpawnReason.NATURAL, this.getLevel(rsp.getLocation()) * (double)rsp.getLevelMod());
    }

    public MythicBukkit getPlugin() {
        return this.plugin;
    }

    public RandomSpawnerManager getManager() {
        return this.manager;
    }

    public String getName() {
        return this.name;
    }

    public RandomSpawnerAction getAction() {
        return this.action;
    }

    public int getPriority() {
        return this.priority;
    }

    public int getMaxSpawnerMobCount() {
        return this.maxSpawnerMobCount;
    }

    public int getMaxLocalMobCount() {
        return this.maxLocalMobCount;
    }

    public PlaceholderDouble getLevel() {
        return this.level;
    }

    public Collection<String> getWorldNames() {
        return this.worldNames;
    }

    public Collection<String> getRegionTags() {
        return this.regionTags;
    }

    public Collection<AbstractWorld> getWorlds() {
        return this.worlds;
    }

    public Collection<AbstractBiome> getBiomes() {
        return this.biomes;
    }

    public Collection<AbstractStructure> getStructures() {
        return this.structures;
    }

    public Collection<CreatureSpawnEvent.SpawnReason> getSpawnReasons() {
        return this.spawnReasons;
    }

    public List<SkillCondition> getConditions() {
        return this.conditions;
    }

    public SpawnPointType getPositionType() {
        return this.positionType;
    }
}

