/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.spawning.random;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractWorld;
import io.lumine.mythic.api.packs.Pack;
import io.lumine.mythic.api.spawning.MythicSpawnState;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.adapters.BukkitEntityType;
import io.lumine.mythic.bukkit.utils.numbers.Numbers;
import io.lumine.mythic.bukkit.utils.plugin.ReloadableModule;
import io.lumine.mythic.core.config.IOHandler;
import io.lumine.mythic.core.config.IOLoader;
import io.lumine.mythic.core.config.MythicConfigImpl;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.spawning.random.RandomSpawnGenerator;
import io.lumine.mythic.core.spawning.random.RandomSpawnPoint;
import io.lumine.mythic.core.spawning.random.RandomSpawner;
import io.lumine.mythic.core.spawning.random.RandomSpawnerAction;
import io.lumine.mythic.core.spawning.random.SpawnPointType;
import io.lumine.mythic.core.spawning.random.generators.ClusterGenerator;
import io.lumine.mythic.core.spawning.random.generators.LegacyGenerator;
import io.lumine.mythic.core.spawning.random.generators.RegionalClusterGenerator;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class RandomSpawnerManager
extends ReloadableModule<MythicBukkit> {
    private List<File> spawnFiles;
    private IOLoader<MythicBukkit> defaultSpawns;
    private List<IOLoader<MythicBukkit>> spawnLoaders;
    private Map<String, Map<SpawnPointType, List<RandomSpawner>>> randomSpawnersAdd = Maps.newConcurrentMap();
    private List<RandomSpawner> randomSpawnersReplace = Lists.newArrayList();
    private List<RandomSpawner> randomSpawnersDeny = Lists.newArrayList();
    private RandomSpawnGenerator generatorTask;

    public RandomSpawnerManager(MythicBukkit core) {
        super(core);
    }

    public void loadRandomSpawns() {
        block21: {
            block20: {
                MythicLogger.log("Loading Random Spawns...");
                this.defaultSpawns = new IOLoader<MythicBukkit>(MythicBukkit.inst(), "ExampleRandomSpawns.yml", "RandomSpawns");
                this.spawnFiles = IOHandler.getAllFiles(this.defaultSpawns.getFile().getParent());
                for (Pack pack : ((MythicBukkit)this.getPlugin()).getPackManager().getPacks()) {
                    for (File folder : pack.getPackFolders("RandomSpawns", true, false)) {
                        this.spawnFiles.addAll(IOHandler.getAllFiles(folder.getAbsolutePath()));
                    }
                }
                this.spawnLoaders = IOHandler.getSaveLoad(MythicBukkit.inst(), this.spawnFiles, "RandomSpawns");
                this.randomSpawnersAdd.clear();
                this.randomSpawnersReplace.clear();
                this.randomSpawnersDeny.clear();
                for (IOLoader iOLoader : this.spawnLoaders) {
                    for (String name : iOLoader.getCustomConfig().getConfigurationSection("").getKeys(false)) {
                        MythicConfigImpl mc = new MythicConfigImpl(name, iOLoader.getCustomConfig());
                        String file = iOLoader.getFile().getName();
                        try {
                            RandomSpawner rs = new RandomSpawner(this, file, name, mc);
                            if (rs.getAction() == RandomSpawnerAction.ADD) {
                                if (!rs.isValid()) {
                                    MythicLogger.errorSpawnConfig(rs, mc, "No valid mob types configured");
                                    continue;
                                }
                                for (String world : rs.getWorldNames()) {
                                    this.randomSpawnersAdd.compute(world, (w, v) -> v == null ? Maps.newConcurrentMap() : v).compute(rs.getPositionType(), (w, v) -> v == null ? Lists.newArrayList() : v).add(rs);
                                }
                                continue;
                            }
                            if (rs.getAction() == RandomSpawnerAction.DENY) {
                                this.randomSpawnersDeny.add(rs);
                                continue;
                            }
                            this.randomSpawnersReplace.add(rs);
                        }
                        catch (Error | Exception ex) {
                            MythicLogger.error("Failed to load RandomSpawner {0} in file {1} - invalid configuration", name, file);
                            ex.printStackTrace();
                        }
                    }
                }
                MythicLogger.debug(MythicLogger.DebugLevel.INFO, "Sorting ADD Random Spawners...", new Object[0]);
                for (Map map : this.randomSpawnersAdd.values()) {
                    for (List types : map.values()) {
                        this.sortSpawners(types);
                    }
                }
                MythicLogger.debug(MythicLogger.DebugLevel.INFO, "Sorting REPLACE Random Spawners...", new Object[0]);
                this.randomSpawnersReplace = this.sortSpawners(this.randomSpawnersReplace);
                if (!((MythicBukkit)this.getPlugin()).getConfiguration().isRandomSpawningGenerationEnabled()) break block20;
                if (this.generatorTask != null) {
                    this.generatorTask.terminate();
                }
                MythicLogger.debug(MythicLogger.DebugLevel.INFO, "Starting up SpawnPointGenerator...", new Object[0]);
                switch (((MythicBukkit)this.getPlugin()).getConfiguration().getRandomSpawningGeneratorType()) {
                    case LEGACY: {
                        if (((MythicBukkit)this.getPlugin()).getConfiguration().getRandomSpawningPointsPerSecond() > 0) {
                            this.generatorTask = new LegacyGenerator(this);
                            break;
                        }
                        break block21;
                    }
                    case CLUSTER: {
                        this.generatorTask = new ClusterGenerator(this);
                        break;
                    }
                    case REGIONAL: {
                        this.generatorTask = new RegionalClusterGenerator(this);
                        break;
                    }
                }
                break block21;
            }
            if (this.generatorTask != null) {
                this.generatorTask.terminate();
                this.generatorTask = null;
            }
        }
    }

    public int getNumberOfSpawners() {
        int i = 0;
        for (Map<SpawnPointType, List<RandomSpawner>> worldSpawners : this.randomSpawnersAdd.values()) {
            for (List<RandomSpawner> types : worldSpawners.values()) {
                i += types.size();
            }
        }
        return i;
    }

    public AbstractEntity handleSpawnEvent(RandomSpawnPoint rsp) {
        if (this.randomSpawnersReplace.isEmpty()) {
            return null;
        }
        if (rsp.getReason() == CreatureSpawnEvent.SpawnReason.NATURAL && BukkitEntityType.getIsSpawning().booleanValue()) {
            return null;
        }
        if (rsp.getEntity() == null) {
            return null;
        }
        if (((MythicBukkit)this.getPlugin()).getConfiguration().isRandomSpawningReplaceObeysCap()) {
            MythicSpawnState spawnState = this.getSpawnState(rsp.getWorld());
            if (rsp.getEntity().isMonster() && spawnState.getMonsterCount() > this.getMythicMobCap(spawnState)) {
                return null;
            }
        }
        for (RandomSpawner RS : this.randomSpawnersReplace) {
            if (!RS.checkSpawn(rsp)) continue;
            ActiveMob mob = RS.spawn(rsp);
            return mob != null ? mob.getEntity() : null;
        }
        return null;
    }

    @Override
    public void load(MythicBukkit plugin) {
        if (this.generatorTask == null) {
            MythicLogger.debug(MythicLogger.DebugLevel.INFO, "Starting up SpawnPointGenerator!", new Object[0]);
            switch (((MythicBukkit)this.getPlugin()).getConfiguration().getRandomSpawningGeneratorType()) {
                case LEGACY: {
                    if (((MythicBukkit)this.getPlugin()).getConfiguration().getRandomSpawningPointsPerSecond() <= 0) break;
                    this.generatorTask = new LegacyGenerator(this);
                    break;
                }
                case CLUSTER: {
                    this.generatorTask = new ClusterGenerator(this);
                    break;
                }
            }
        }
    }

    @Override
    public void unload() {
        if (this.generatorTask != null) {
            this.generatorTask.terminate();
            this.generatorTask = null;
        }
    }

    public MythicSpawnState getSpawnState(AbstractWorld world) {
        return ((MythicBukkit)this.getPlugin()).getVolatileCodeHandler().getSpawningHandler().getSpawnState(world);
    }

    public int getMythicMobCap(AbstractWorld world) {
        return this.getMythicMobCap(this.getSpawnState(world));
    }

    public int getMythicMobCap(MythicSpawnState state) {
        int limit = ((MythicBukkit)this.getPlugin()).getConfiguration().getRandomSpawningLimit();
        if (limit == 0) {
            return Integer.MAX_VALUE;
        }
        if (limit < 0) {
            return Numbers.floor((double)state.getMaxMobCount() * ((MythicBukkit)this.getPlugin()).getConfiguration().getRandomSpawningLimitMultiplier());
        }
        return limit;
    }

    public boolean doSpawns(RandomSpawnPoint rsp, Collection<RandomSpawner> spawners) {
        if (rsp == null || !rsp.getLocation().isLoaded() || spawners == null) {
            return false;
        }
        for (RandomSpawner spawner : spawners) {
            if (!spawner.checkSpawn(rsp)) continue;
            spawner.spawn(rsp);
            return true;
        }
        return false;
    }

    private List<RandomSpawner> sortSpawners(List<RandomSpawner> list) {
        int i;
        for (i = 0; i < list.size(); ++i) {
            for (int q = 1; q < list.size() - i; ++q) {
                RandomSpawner o = list.get(q - 1);
                RandomSpawner n = list.get(q);
                if (o.getPriority() >= n.getPriority()) continue;
                list.set(q - 1, n);
                list.set(q, o);
            }
        }
        MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Random Spawns Sorted to:", new Object[0]);
        for (i = 0; i < list.size(); ++i) {
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "* " + list.get(i).getPriority() + " = " + list.get(i).getName(), new Object[0]);
        }
        return list;
    }

    public void spawnMobs() {
        RandomSpawnGenerator randomSpawnGenerator;
        if (this.generatorTask != null && (randomSpawnGenerator = this.generatorTask) instanceof LegacyGenerator) {
            LegacyGenerator oldGenerator = (LegacyGenerator)randomSpawnGenerator;
            oldGenerator.spawnMobs();
        }
    }

    public Map<String, Map<SpawnPointType, List<RandomSpawner>>> getRandomSpawnersAdd() {
        return this.randomSpawnersAdd;
    }

    public List<RandomSpawner> getRandomSpawnersReplace() {
        return this.randomSpawnersReplace;
    }

    public List<RandomSpawner> getRandomSpawnersDeny() {
        return this.randomSpawnersDeny;
    }
}

