/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.spawning.random.generators;

import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.adapters.AbstractWorld;
import io.lumine.mythic.api.spawning.MythicSpawnState;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.lib.math3.ml.clustering.DBSCANClusterer;
import io.lumine.mythic.bukkit.utils.lib.math3.ml.clustering.DoublePoint;
import io.lumine.mythic.core.spawning.random.PlayerGroup;
import io.lumine.mythic.core.spawning.random.RandomSpawnGenerator;
import io.lumine.mythic.core.spawning.random.RandomSpawnPoint;
import io.lumine.mythic.core.spawning.random.RandomSpawner;
import io.lumine.mythic.core.spawning.random.RandomSpawnerManager;
import io.lumine.mythic.core.spawning.random.SpawnPointType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.entity.SpawnCategory;

public class ClusterGenerator
extends RandomSpawnGenerator {
    public ClusterGenerator(RandomSpawnerManager manager) {
        super(manager);
    }

    protected boolean isApplicableWorld(AbstractWorld world) {
        return this.getManager().getRandomSpawnersAdd().containsKey(world.getName());
    }

    protected Map<SpawnPointType, List<RandomSpawner>> getApplicableSpawners(RandomSpawnPoint point) {
        return this.getManager().getRandomSpawnersAdd().get(point.getWorld().getName());
    }

    @Override
    public void tick() {
        long startTime = System.currentTimeMillis();
        for (AbstractWorld world : this.getPlugin().getBootstrap().getWorlds()) {
            if (world.getPlayers().isEmpty() || !this.isApplicableWorld(world)) continue;
            List<PlayerGroup> playerGroups = this.getPlayerGroups(world);
            MythicSpawnState spawnState = this.getPlugin().getVolatileCodeHandler().getSpawningHandler().getSpawnState(world);
            if (spawnState.getMonsterCount() > this.getManager().getMythicMobCap(spawnState)) continue;
            Collections.shuffle(playerGroups);
            block1: for (PlayerGroup playerGroup : playerGroups) {
                RandomSpawnPoint spawnLocation;
                PlayerGroup.LocalMobData localMobData = playerGroup.getLocalMobData();
                Map<SpawnCategory, Integer> mobTypeCounts = localMobData.getLocalMobCount();
                Integer localMobCount = mobTypeCounts.values().stream().reduce(0, Integer::sum);
                Integer localMonsterCount = mobTypeCounts.getOrDefault(SpawnCategory.MONSTER, 0);
                double localMobCap = (double)spawnState.getMaxMobsPerPlayer() * this.getPlugin().getConfiguration().getRandomSpawningLimitMultiplier();
                if (playerGroup.getPlayers().size() > 1) {
                    localMobCap *= (double)(playerGroup.getPlayers().size() - 1) * this.getPlugin().getConfiguration().getRandomSpawningGroupMultiplier();
                }
                if ((double)localMonsterCount.intValue() > localMobCap || (double)localMobCount.intValue() > localMobCap * 2.0 || (spawnLocation = playerGroup.getRandomSpawnablePoint()) == null) continue;
                spawnLocation.setNearbyPlayers(playerGroup.getPlayers().size());
                spawnLocation.setLocalMobCount(localMobCount.intValue());
                for (RandomSpawner spawner : this.getApplicableSpawners(spawnLocation).getOrDefault((Object)spawnLocation.getPointType(), Collections.emptyList())) {
                    if (!spawner.checkSpawn(spawnLocation)) continue;
                    if (spawner.getMaxSpawnerMobCount() > 0) {
                        Map<String, Integer> localMobTypes = localMobData.getLocalMobTypes();
                        int count = 0;
                        for (String type : spawner.getConfiguredMobTypes()) {
                            count += localMobTypes.getOrDefault(type, 0).intValue();
                        }
                        if (count >= spawner.getMaxSpawnerMobCount()) continue;
                    }
                    Schedulers.sync().run(() -> spawner.spawn(spawnLocation));
                    continue block1;
                }
            }
        }
    }

    private List<PlayerGroup> getPlayerGroups(AbstractWorld world) {
        double groupingRadius = this.getPlugin().getConfiguration().getRandomSpawningGroupDistance();
        List points = world.getPlayers().stream().map(e -> new DoublePoint(new double[]{e.getLocation().getX(), e.getLocation().getZ()})).collect(Collectors.toList());
        DBSCANClusterer clusterer = new DBSCANClusterer(groupingRadius, 0);
        ArrayList<PlayerGroup> clusters = new ArrayList<PlayerGroup>();
        clusterer.cluster(points).forEach(cluster -> {
            List<AbstractPlayer> clusterEntities = cluster.getPoints().stream().map(dp -> world.getPlayers().get(points.indexOf(dp))).collect(Collectors.toList());
            clusters.add(new PlayerGroup(this.getManager(), world, clusterEntities));
        });
        return clusters;
    }
}

