/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.spawning.random.generators;

import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.logging.Log;
import io.lumine.mythic.core.skills.pins.PinRegion;
import io.lumine.mythic.core.spawning.random.RandomSpawnPoint;
import io.lumine.mythic.core.spawning.random.RandomSpawner;
import io.lumine.mythic.core.spawning.random.RandomSpawnerManager;
import io.lumine.mythic.core.spawning.random.SpawnPointType;
import io.lumine.mythic.core.spawning.random.generators.ClusterGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RegionalClusterGenerator
extends ClusterGenerator {
    private final Map<String, Map<String, Map<SpawnPointType, List<RandomSpawner>>>> worldTagCache;

    public RegionalClusterGenerator(RandomSpawnerManager manager) {
        super(manager);
        Map<String, Map<SpawnPointType, List<RandomSpawner>>> spawnerMap = manager.getRandomSpawnersAdd();
        HashMap cache = new HashMap();
        for (Map.Entry<String, Map<SpawnPointType, List<RandomSpawner>>> worldEntry : spawnerMap.entrySet()) {
            String world = worldEntry.getKey();
            HashMap<String, Map> tagMap = new HashMap<String, Map>();
            for (Map.Entry<SpawnPointType, List<RandomSpawner>> typeEntry : worldEntry.getValue().entrySet()) {
                SpawnPointType type = typeEntry.getKey();
                for (RandomSpawner spawner : typeEntry.getValue()) {
                    for (String tag : spawner.getRegionTags()) {
                        tagMap.computeIfAbsent(tag, k -> new HashMap()).computeIfAbsent(type, k -> new ArrayList()).add(spawner);
                    }
                }
            }
            cache.put(world, Collections.unmodifiableMap(tagMap));
        }
        this.worldTagCache = Collections.unmodifiableMap(cache);
    }

    @Override
    protected Map<SpawnPointType, List<RandomSpawner>> getApplicableSpawners(RandomSpawnPoint point) {
        HashMap<SpawnPointType, List<RandomSpawner>> result = new HashMap<SpawnPointType, List<RandomSpawner>>();
        String worldName = point.getWorld().getName();
        Map<String, Map<SpawnPointType, List<RandomSpawner>>> tagMap = this.worldTagCache.get(worldName);
        if (tagMap == null) {
            return result;
        }
        List<PinRegion> regions = ((MythicBukkit)this.getManager().getPlugin()).getPinManager().getRegions(point.getLocation());
        if (regions == null || regions.isEmpty()) {
            return result;
        }
        ArrayList<String> regionTags = new ArrayList<String>();
        for (PinRegion region : regions) {
            regionTags.addAll(region.getTags());
        }
        for (String tag : regionTags) {
            Map<SpawnPointType, List<RandomSpawner>> typeMap = tagMap.get(tag);
            if (typeMap == null) continue;
            for (Map.Entry<SpawnPointType, List<RandomSpawner>> entry : typeMap.entrySet()) {
                SpawnPointType type = entry.getKey();
                result.computeIfAbsent(type, k -> new ArrayList()).addAll((Collection)entry.getValue());
            }
        }
        return result;
    }

    public void tickz() {
        long start = System.nanoTime();
        super.tick();
        long end = System.nanoTime();
        Log.info("Regional Generator tick {0}", end - start);
    }
}

