/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.volatilecode.v1_20_R3;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.lumine.mythic.api.adapters.AbstractBlock;
import io.lumine.mythic.api.adapters.AbstractDirection;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.volatilecode.VolatileCodeHandler;
import io.lumine.mythic.api.volatilecode.handlers.VolatileBlockHandler;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.adapters.BukkitBlock;
import io.lumine.mythic.bukkit.utils.Players;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.reflection.Reflector;
import io.lumine.mythic.core.logging.MythicLogger;
import it.unimi.dsi.fastutil.shorts.ShortArraySet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import java.lang.reflect.Constructor;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.SectionPosition;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBundlePacket;
import net.minecraft.network.protocol.game.PacketPlayOutBlockAction;
import net.minecraft.network.protocol.game.PacketPlayOutBlockBreakAnimation;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityVelocity;
import net.minecraft.network.protocol.game.PacketPlayOutMultiBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.EntityFallingBlock;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockBell;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.piston.BlockPiston;
import net.minecraft.world.level.block.piston.BlockPistonMoving;
import net.minecraft.world.level.block.piston.PistonExtendsChecker;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyPistonType;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.Powerable;
import org.bukkit.block.data.type.Piston;
import org.bukkit.craftbukkit.v1_20_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R3.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftPlayer;
import org.bukkit.entity.Player;

public class VolatileBlockHandlerImpl
implements VolatileBlockHandler {
    public VolatileBlockHandlerImpl(VolatileCodeHandler handler) {
    }

    @Override
    public void sendBlockChange(Collection<AbstractPlayer> audience, AbstractLocation location, AbstractBlock block) {
        IBlockData blockState;
        BlockPosition blockPosition = new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        if (block == null) {
            WorldServer nmsWorld = ((CraftWorld)BukkitAdapter.adapt(location).getWorld()).getHandle();
            blockState = nmsWorld.a_(blockPosition);
        } else if (block instanceof BukkitBlock) {
            BukkitBlock bukkitBlock = (BukkitBlock)block;
            blockState = ((CraftBlockData)bukkitBlock.getBlockData()).getState();
        } else {
            return;
        }
        PacketPlayOutBlockChange packet = new PacketPlayOutBlockChange(blockPosition, blockState);
        for (AbstractPlayer player : audience) {
            EntityPlayer nmsPlayer = ((CraftPlayer)BukkitAdapter.adapt(player)).getHandle();
            nmsPlayer.c.b((Packet)packet);
        }
    }

    @Override
    public void sendMultiBlockChange(Collection<AbstractPlayer> audience, Map<AbstractLocation, AbstractBlock> changeMap) {
        if (changeMap.isEmpty()) {
            return;
        }
        for (PacketPlayOutMultiBlockChange packet : VolatileBlockHandlerImpl.getSectionUpdatePackets(changeMap)) {
            for (AbstractPlayer player : audience) {
                EntityPlayer nmsPlayer = ((CraftPlayer)BukkitAdapter.adapt(player)).getHandle();
                nmsPlayer.c.b((Packet)packet);
            }
        }
    }

    public static Collection<PacketPlayOutMultiBlockChange> getSectionUpdatePackets(Map<AbstractLocation, AbstractBlock> changeMap) {
        LinkedHashMap blocksMap = Maps.newLinkedHashMap();
        for (Map.Entry<AbstractLocation, AbstractBlock> entry : changeMap.entrySet()) {
            IBlockData blockState;
            AbstractLocation location = entry.getKey();
            WorldServer nmsWorld = ((CraftWorld)BukkitAdapter.adapt(location).getWorld()).getHandle();
            AbstractBlock aBlockData = entry.getValue();
            BlockPosition blockPosition = new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ());
            SectionPosition section = SectionPosition.a((BlockPosition)blockPosition);
            if (!blocksMap.containsKey(section)) {
                blocksMap.put(section, Maps.newLinkedHashMap());
            }
            if (aBlockData == null) {
                blockState = nmsWorld.a_(blockPosition);
            } else {
                if (!(aBlockData instanceof BukkitBlock)) continue;
                BukkitBlock bukkitBlock = (BukkitBlock)aBlockData;
                blockState = ((CraftBlockData)bukkitBlock.getBlockData()).getState();
            }
            ((Map)blocksMap.get(section)).put(SectionPosition.b((BlockPosition)blockPosition), blockState);
        }
        ArrayList packets = Lists.newArrayList();
        for (Map.Entry entry : blocksMap.entrySet()) {
            SectionPosition section = (SectionPosition)entry.getKey();
            ShortArraySet shortArraySet = new ShortArraySet();
            shortArraySet.addAll(((Map)entry.getValue()).keySet());
            IBlockData[] blockData = ((Map)entry.getValue()).values().toArray(new IBlockData[0]);
            packets.add(new PacketPlayOutMultiBlockChange(section, (ShortSet)shortArraySet, blockData));
        }
        return packets;
    }

    @Override
    public void applyPhysics(org.bukkit.block.Block target) {
        Location location = target.getLocation();
        WorldServer world = ((CraftWorld)location.getWorld()).getHandle();
        BlockPosition blockposition = new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        IBlockData iblockdata = world.a_(blockposition);
        Block block = iblockdata.b();
        world.b(blockposition, block);
    }

    @Override
    public void togglePowerable(AbstractLocation location) {
        this.togglePowerable(location, 0L);
    }

    @Override
    public void togglePowerable(AbstractLocation location, long duration) {
        Location l = BukkitAdapter.adapt(location);
        org.bukkit.block.Block block = l.getWorld().getBlockAt(l);
        BlockData bd = block.getBlockData();
        if (bd instanceof Powerable) {
            Powerable pbd = (Powerable)bd;
            pbd.setPowered(true);
            block.setBlockData((BlockData)pbd);
            this.applyPhysics(block);
            Schedulers.sync().runLater(() -> {
                pbd.setPowered(false);
                block.setBlockData((BlockData)pbd);
                this.applyPhysics(block);
            }, duration);
        }
    }

    @Override
    public void togglePiston(AbstractLocation target) {
        Location location = BukkitAdapter.adapt(target);
        org.bukkit.block.Block block = location.getBlock();
        if (block.getType() != Material.PISTON) {
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Location was not piston", new Object[0]);
            return;
        }
        BlockData bd = block.getBlockData();
        Piston redstone = (Piston)bd;
        boolean extended = redstone.isExtended();
        BlockFace bf = ((Directional)bd).getFacing();
        if (extended) {
            redstone.setExtended(false);
            block.setBlockData((BlockData)redstone);
        }
        redstone.setExtended(true);
        block.setBlockData((BlockData)redstone);
        WorldServer world = ((CraftWorld)location.getWorld()).getHandle();
        BlockPosition blockposition = new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        IBlockData iblockdata = world.a_(blockposition);
        boolean bold = BlockPiston.a((IBlockData)iblockdata, (World)world, (BlockPosition)blockposition, (EnumDirection)EnumDirection.c, (boolean)true, (EnumDirection)EnumDirection.d);
        if (!bold) {
            redstone.setExtended(false);
            block.setBlockData((BlockData)redstone);
        }
    }

    @Override
    public void throwBlock(AbstractLocation target, Material material, AbstractVector velocity, int duration, boolean hideSourceBlock) {
        Location location = BukkitAdapter.adapt(target);
        BlockPosition blockPosition = new BlockPosition(target.getBlockX(), target.getBlockY(), target.getBlockZ());
        CraftWorld bukkitWorld = (CraftWorld)location.getWorld();
        WorldServer nmsWorld = bukkitWorld.getHandle();
        IBlockData blockState = material == null ? nmsWorld.a_(blockPosition) : ((CraftBlockData)Bukkit.createBlockData((Material)material)).getState();
        try {
            Constructor<EntityFallingBlock> ref = Reflector.getConstructor(EntityFallingBlock.class, World.class, Double.class, Double.class, Double.class, IBlockData.class);
            ref.setAccessible(true);
            EntityFallingBlock block = ref.newInstance(nmsWorld, (double)target.getBlockX() + 0.5, target.getBlockY() + 1, (double)target.getBlockZ() + 0.5, blockState);
            PacketPlayOutSpawnEntity packet = new PacketPlayOutSpawnEntity((Entity)block, BlockBell.i((IBlockData)blockState), blockPosition);
            PacketPlayOutEntityVelocity packetV = new PacketPlayOutEntityVelocity(block.aj(), new Vec3D(velocity.getX(), velocity.getY(), velocity.getZ()));
            for (EntityPlayer p : nmsWorld.a(sp -> sp.dM().equals(nmsWorld))) {
                if (hideSourceBlock) {
                    p.getBukkitEntity().sendBlockChange(location, Material.AIR, (byte)0);
                }
                p.c.b((Packet)packet);
                p.c.b((Packet)packetV);
                Schedulers.async().runLater(() -> {
                    PacketPlayOutEntityDestroy packet2 = new PacketPlayOutEntityDestroy(new int[]{block.aj()});
                    p.c.b((Packet)packet2);
                    if (hideSourceBlock) {
                        p.getBukkitEntity().sendBlockChange(location, location.getBlock().getBlockData());
                    }
                }, duration);
            }
        }
        catch (Error | Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean pushBlock(AbstractLocation location, AbstractDirection direction) {
        WorldServer world = ((CraftWorld)BukkitAdapter.adapt(location).getWorld()).getHandle();
        EnumDirection movingDirection = EnumDirection.valueOf((String)direction.toString());
        BlockPosition blockMovedPosition = new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        BlockPosition blockMovingPosition = blockMovedPosition.a(movingDirection.g());
        BlockPosition blockFakeHeadPosition = blockMovingPosition.a(EnumDirection.c);
        IBlockData blockMovedState = world.a_(blockMovedPosition);
        IBlockData blockMovingState = world.a_(blockMovingPosition);
        IBlockData fakeHeadState = world.a_(blockFakeHeadPosition);
        IBlockData pistonState = (IBlockData)Blocks.by.o().a((IBlockState)BlockProperties.P, (Comparable)movingDirection);
        IBlockData airState = Blocks.a.o();
        PacketPlayOutBlockChange packetBlock = new PacketPlayOutBlockChange(blockMovingPosition, pistonState);
        PacketPlayOutBlockAction packetPush = new PacketPlayOutBlockAction(blockMovingPosition, blockMovingState.b(), 0, movingDirection.ordinal());
        PacketPlayOutBlockAction packetCancel = new PacketPlayOutBlockAction(blockMovingPosition, blockMovingState.b(), 2, movingDirection.ordinal());
        PacketPlayOutBlockChange packetBlockBye1 = new PacketPlayOutBlockChange(blockMovingPosition, blockMovingState);
        PacketPlayOutBlockChange packetBlockBye2 = new PacketPlayOutBlockChange(blockMovedPosition, airState);
        PacketPlayOutBlockChange packetBlockBye3 = new PacketPlayOutBlockChange(blockFakeHeadPosition, fakeHeadState);
        ClientboundBundlePacket bundle = new ClientboundBundlePacket(List.of(packetBlock, packetPush, packetBlockBye1, packetBlockBye2, packetBlockBye3));
        Schedulers.ensureAsync(() -> {
            for (Player player : Players.all()) {
                ((CraftPlayer)player).getHandle().c.b((Packet)bundle);
            }
        });
        return this.moveBlocks((World)world, blockMovingPosition, movingDirection, true);
    }

    private boolean moveBlocks(World world, BlockPosition blockposition, EnumDirection direction, boolean isExtending) {
        int i;
        IBlockData blockState;
        BlockPosition blockPos;
        int i2;
        BlockPosition newBlockPosition = blockposition.a(direction);
        PistonExtendsChecker pistonStructureResolver = new PistonExtendsChecker(world, blockposition, direction, isExtending);
        if (!pistonStructureResolver.a()) {
            return false;
        }
        HashMap blocksToPushStates = Maps.newHashMap();
        List blocksToPush = pistonStructureResolver.c();
        ArrayList blocksToPushStatesList = Lists.newArrayList();
        for (BlockPosition blockPos2 : blocksToPush) {
            IBlockData blockState2 = world.a_(blockPos2);
            blocksToPushStates.put(blockPos2, blockState2);
            blocksToPushStatesList.add(blockState2);
        }
        List blocksToDestroy = pistonStructureResolver.d();
        IBlockData[] aiblockdata = new IBlockData[blocksToPush.size() + blocksToDestroy.size()];
        EnumDirection directionMovement = isExtending ? direction : direction.g();
        final org.bukkit.block.Block baseBlock = world.getWorld().getBlockAt(blockposition.u(), blockposition.v(), blockposition.w());
        final List moved = pistonStructureResolver.c();
        final List broken = pistonStructureResolver.d();
        IBlockData blockStateAir = Blocks.a.o();
        AbstractList<org.bukkit.block.Block> blocks = new AbstractList<org.bukkit.block.Block>(this){
            final /* synthetic */ VolatileBlockHandlerImpl this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public int size() {
                return moved.size() + broken.size();
            }

            @Override
            public org.bukkit.block.Block get(int index) {
                if (index >= this.size() || index < 0) {
                    throw new ArrayIndexOutOfBoundsException(index);
                }
                BlockPosition pos = index < moved.size() ? (BlockPosition)moved.get(index) : (BlockPosition)broken.get(index - moved.size());
                return baseBlock.getWorld().getBlockAt(pos.u(), pos.v(), pos.w());
            }
        };
        int j = 0;
        for (i2 = blocksToDestroy.size() - 1; i2 >= 0; --i2) {
            blockPos = (BlockPosition)blocksToDestroy.get(i2);
            IBlockData blockState3 = world.a_(blockPos);
            world.a(blockPos, Blocks.a.o(), 18);
            if (!blockState3.a(TagsBlock.aJ)) {
                world.a(blockPos, blockState3);
            }
            aiblockdata[j++] = blockState3;
        }
        for (i2 = blocksToPush.size() - 1; i2 >= 0; --i2) {
            blockPos = (BlockPosition)blocksToPush.get(i2);
            BlockPosition blockPosNew = blockPos.a(directionMovement);
            blockState = world.a_(blockPos);
            IBlockData movingPistonState = (IBlockData)Blocks.bQ.o().a((IBlockState)BlockProperties.P, (Comparable)direction);
            blocksToPushStates.remove(blockPosNew);
            world.a(blockPosNew, movingPistonState, 68);
            world.a(BlockPistonMoving.a((BlockPosition)blockPosNew, (IBlockData)movingPistonState, (IBlockData)((IBlockData)blocksToPushStatesList.get(i2)), (EnumDirection)direction, (boolean)isExtending, (boolean)false));
            aiblockdata[j++] = blockState;
        }
        if (isExtending) {
            BlockPropertyPistonType blockpropertypistontype = BlockPropertyPistonType.a;
            IBlockData iblockdata1 = (IBlockData)((IBlockData)Blocks.bQ.o().a((IBlockState)BlockPistonMoving.b, (Comparable)direction)).a((IBlockState)BlockPistonMoving.c, (Comparable)BlockPropertyPistonType.a);
            blocksToPushStates.remove(newBlockPosition);
            world.a(newBlockPosition, iblockdata1, 68);
            world.a(BlockPistonMoving.a((BlockPosition)newBlockPosition, (IBlockData)iblockdata1, (IBlockData)blockStateAir, (EnumDirection)direction, (boolean)true, (boolean)true));
        }
        Iterator iterator = blocksToPushStates.keySet().iterator();
        while (iterator.hasNext()) {
            world.a((BlockPosition)iterator.next(), blockStateAir, 82);
        }
        for (Map.Entry entry : blocksToPushStates.entrySet()) {
            BlockPosition blockPos3 = (BlockPosition)entry.getKey();
            IBlockData blockState4 = (IBlockData)entry.getValue();
            blockState4.b((GeneratorAccess)world, blockPos3, 2);
            blockStateAir.a((GeneratorAccess)world, blockPos3, 2);
            blockStateAir.b((GeneratorAccess)world, blockPos3, 2);
        }
        j = 0;
        for (i = blocksToDestroy.size() - 1; i >= 0; --i) {
            blockState = aiblockdata[j++];
            BlockPosition blockPos4 = (BlockPosition)blocksToDestroy.get(i);
            blockState.b((GeneratorAccess)world, blockPos4, 2);
            world.a(blockPos4, blockState.b());
        }
        for (i = blocksToPush.size() - 1; i >= 0; --i) {
            world.a((BlockPosition)blocksToPush.get(i), aiblockdata[j++].b());
        }
        return true;
    }

    @Override
    public void sendBlockDamaged(Collection<AbstractPlayer> audience, AbstractLocation location, int damage) {
        BlockPosition block = new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        int id = (block.u() & 0xFFF) << 20 | (block.w() & 0xFFF) << 8 | block.v() & 0xFF;
        MythicClientboundBlockDestructionPacket packet = new MythicClientboundBlockDestructionPacket(id, block, damage);
        for (AbstractPlayer player : audience) {
            EntityPlayer nmsPlayer = ((CraftPlayer)BukkitAdapter.adapt(player)).getHandle();
            nmsPlayer.c.b((Packet)packet);
        }
    }

    public static class MythicClientboundBlockDestructionPacket
    extends PacketPlayOutBlockBreakAnimation {
        public MythicClientboundBlockDestructionPacket(int id, BlockPosition pos, int damage) {
            super(id, pos, damage);
        }
    }
}

