/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.volatilecode.v1_20_R4.ai.targeters;

import com.google.common.collect.Sets;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.mobs.ai.WrappedPathfindingGoal;
import io.lumine.mythic.core.utils.annotations.MythicAIGoal;
import io.lumine.mythic.core.volatilecode.v1_20_R4.ai.PathfinderHolder;
import java.util.Optional;
import java.util.Set;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import org.bukkit.entity.Entity;

@MythicAIGoal(name="nearestSpecificFaction", aliases={"specificFaction"}, description="Target a nearby entity that is in a specific faction")
public class SpecificFactionGoal
extends WrappedPathfindingGoal
implements PathfinderHolder {
    private Set<String> faction = Sets.newHashSet();

    public SpecificFactionGoal(AbstractEntity entity, String line, MythicLineConfig mlc) {
        super(entity, line, mlc);
        String[] split;
        String factions = mlc.getString(new String[]{"faction", "f"}, this.dataVar1, new String[0]);
        if (factions == null) {
            return;
        }
        for (String s2 : split = factions.split(",")) {
            this.faction.add(s2.toUpperCase());
        }
    }

    @Override
    public boolean isValid() {
        return this.entity.isCreature();
    }

    @Override
    public PathfinderGoal create() {
        return new PathfinderGoalNearestAttackableTarget((EntityInsentient)PathfinderHolder.getNMSEntity(this.entity), EntityLiving.class, 0, true, false, targetEntity -> {
            try {
                ActiveMob mob = SpecificFactionGoal.getPlugin().getMobManager().getMythicMobInstance(this.getEntity());
                AbstractEntity target = BukkitAdapter.adapt((Entity)((EntityLiving)targetEntity).getBukkitEntity());
                if (mob == null) {
                    return false;
                }
                if (target.isPlayer()) {
                    for (String faction : this.faction) {
                        if (!SpecificFactionGoal.getPlugin().getPlayerManager().getFactionProvider().isInFaction(target.asPlayer(), faction)) continue;
                        return true;
                    }
                } else {
                    Optional<ActiveMob> maybeTargetAM = SpecificFactionGoal.getPlugin().getMobManager().getActiveMob(target.getUniqueId());
                    if (!maybeTargetAM.isPresent()) {
                        return false;
                    }
                    ActiveMob targetAM = maybeTargetAM.get();
                    if (targetAM.hasFaction()) {
                        String faction = targetAM.getFaction().toUpperCase();
                        return this.faction.contains(faction);
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return false;
        });
    }
}

