/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.shadow;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.checkerframework.checker.nullness.qual.NonNull;

final class Reflection {
    public static void ensureStatic(Member member) {
        if (!Modifier.isStatic(member.getModifiers())) {
            throw new IllegalArgumentException();
        }
    }

    public static <T> @NonNull T getInstance(@NonNull Class<T> returnType, @NonNull Class<? extends T> implementationType) {
        try {
            Method getInstanceMethod = implementationType.getDeclaredMethod("getInstance", new Class[0]);
            Reflection.ensureStatic(getInstanceMethod);
            if (getInstanceMethod.getParameterCount() != 0) {
                throw new IllegalArgumentException();
            }
            if (!returnType.isAssignableFrom(getInstanceMethod.getReturnType())) {
                throw new IllegalArgumentException();
            }
            Reflection.ensureAccessible(getInstanceMethod);
            return (T)getInstanceMethod.invoke(null, new Object[0]);
        }
        catch (Exception getInstanceMethod) {
            T[] enumConstants;
            if (implementationType.isEnum() && (enumConstants = implementationType.getEnumConstants()).length == 1) {
                return enumConstants[0];
            }
            try {
                Field instanceField = implementationType.getDeclaredField("instance");
                Reflection.ensureStatic(instanceField);
                if (!returnType.isAssignableFrom(instanceField.getType())) {
                    throw new IllegalArgumentException();
                }
                Reflection.ensureAccessible(instanceField);
                return (T)instanceField.get(null);
            }
            catch (Exception instanceField) {
                try {
                    Field instanceField2 = implementationType.getDeclaredField("INSTANCE");
                    Reflection.ensureStatic(instanceField2);
                    if (!returnType.isAssignableFrom(instanceField2.getType())) {
                        throw new IllegalArgumentException();
                    }
                    Reflection.ensureAccessible(instanceField2);
                    return (T)instanceField2.get(null);
                }
                catch (Exception instanceField2) {
                    try {
                        Constructor<T> constructor = implementationType.getDeclaredConstructor(new Class[0]);
                        Reflection.ensureAccessible(constructor);
                        return constructor.newInstance(new Object[0]);
                    }
                    catch (Exception exception) {
                        throw new RuntimeException("Unable to obtain an instance of " + implementationType.getName());
                    }
                }
            }
        }
    }

    public static void ensureAccessible(AccessibleObject accessibleObject) {
        if (!accessibleObject.isAccessible()) {
            accessibleObject.setAccessible(true);
        }
    }

    public static void ensureModifiable(Field field) {
        if (Modifier.isFinal(field.getModifiers())) {
            try {
                Field modifierField = Field.class.getDeclaredField("modifiers");
                modifierField.setAccessible(true);
                modifierField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static Field findField(Class<?> searchClass, String fieldName) {
        Field field = null;
        do {
            try {
                field = searchClass.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException ignored) {
                searchClass = searchClass.getSuperclass();
            }
        } while (field == null && searchClass != Object.class);
        return field;
    }

    private Reflection() {
    }
}

