/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.shadow;

import io.lumine.shadow.ClassTarget;
import io.lumine.shadow.DynamicClassTarget;
import io.lumine.shadow.DynamicFieldTarget;
import io.lumine.shadow.DynamicMethodTarget;
import io.lumine.shadow.FuzzyFieldTargetResolver;
import io.lumine.shadow.Shadow;
import io.lumine.shadow.Target;
import io.lumine.shadow.TargetResolver;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import org.checkerframework.checker.nullness.qual.NonNull;

final class TargetLookup
implements TargetResolver {
    private final @NonNull List<TargetResolver> resolvers = new CopyOnWriteArrayList<TargetResolver>(Arrays.asList(ClassTarget.RESOLVER, Target.RESOLVER, DynamicClassTarget.RESOLVER, DynamicMethodTarget.RESOLVER, DynamicFieldTarget.RESOLVER, FuzzyFieldTargetResolver.INSTANCE));

    TargetLookup() {
    }

    public void registerResolver(@NonNull TargetResolver targetResolver) {
        Objects.requireNonNull(targetResolver, "targetResolver");
        if (!this.resolvers.contains(targetResolver)) {
            this.resolvers.add(0, targetResolver);
        }
    }

    @Override
    public @NonNull Optional<Class<?>> lookupClass(@NonNull Class<? extends Shadow> shadowClass) throws ClassNotFoundException {
        for (TargetResolver resolver : this.resolvers) {
            Optional<Class<?>> result = resolver.lookupClass(shadowClass);
            if (!result.isPresent()) continue;
            return result;
        }
        return Optional.empty();
    }

    @Override
    public @NonNull Optional<String> lookupMethod(@NonNull Method shadowMethod, @NonNull Class<? extends Shadow> shadowClass, @NonNull Class<?> targetClass) {
        for (TargetResolver resolver : this.resolvers) {
            Optional<String> result = resolver.lookupMethod(shadowMethod, shadowClass, targetClass);
            if (!result.isPresent()) continue;
            return result;
        }
        return Optional.empty();
    }

    @Override
    public @NonNull Optional<String> lookupField(@NonNull Method shadowMethod, @NonNull Class<? extends Shadow> shadowClass, @NonNull Class<?> targetClass) {
        for (TargetResolver resolver : this.resolvers) {
            Optional<String> result = resolver.lookupField(shadowMethod, shadowClass, targetClass);
            if (!result.isPresent()) continue;
            return result;
        }
        return Optional.empty();
    }
}

