/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owosentinel;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.wispforest.owosentinel.SentinelConsole;
import io.wispforest.owosentinel.SentinelWindow;
import java.awt.GraphicsEnvironment;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModDependency;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OwoSentinel {
    public static final Logger LOGGER = LogManager.getLogger((String)"o\u03c9o-sentinel");
    private static final Gson GSON = new Gson();
    public static final String OWO_EXPLANATION = "o\u03c9o-lib is a library used by most mods under the\nWisp Forest domain to ease development. This is\nsimply a convenient installer, as o\u03c9o is missing from your\ninstallation. Should you not trust it, feel free to head to the\nrepository and download o\u03c9o yourself.\n";
    public static final boolean FORCE_HEADLESS = Boolean.getBoolean("owo.sentinel.forceHeadless");

    public static void launch() {
        if (FabricLoader.getInstance().isModLoaded("owo-impl")) {
            return;
        }
        try {
            if (GraphicsEnvironment.isHeadless() || FORCE_HEADLESS || System.getProperty("os.name").toLowerCase(Locale.ROOT).contains("mac")) {
                SentinelConsole.run();
            } else {
                SentinelWindow.open();
            }
        }
        catch (Exception e) {
            LOGGER.error("Error thrown while opening sentinel! Exiting", (Throwable)e);
            System.exit(1);
        }
        System.exit(0);
    }

    public static List<String> listOwoDependents() {
        ArrayList<String> list = new ArrayList<String>();
        HashSet<String> used = new HashSet<String>();
        for (ModContainer mod2 : FabricLoader.getInstance().getAllMods()) {
            for (ModDependency dependency : mod2.getMetadata().getDependencies()) {
                if (!dependency.getModId().equals("owo") && !dependency.getModId().equals("owo-lib")) continue;
                list.add(mod2.getMetadata().getName() + " (explicit dependency)");
                used.add(mod2.getMetadata().getId());
            }
        }
        FabricLoader.getInstance().getModContainer("owo-sentinel").flatMap(ModContainer::getContainingMod).ifPresent(mod -> {
            if (used.contains(mod.getMetadata().getId())) {
                return;
            }
            list.add(mod.getMetadata().getName() + " (included sentinel)");
        });
        return list;
    }

    public static void downloadAndInstall(Consumer<String> logger) throws Exception {
        logger.accept("Fetching versions");
        URL url = new URL("https://api.modrinth.com/v2/project/owo-lib/version?game_versions=[%221.20.2%22]&loaders=[%22fabric%22]");
        JsonArray response = (JsonArray)GSON.fromJson((Reader)new InputStreamReader(url.openStream()), JsonArray.class);
        String targetVersion = ((ModContainer)FabricLoader.getInstance().getModContainer("owo-sentinel").orElseThrow()).getMetadata().getVersion().getFriendlyString();
        JsonObject latestVersion = null;
        for (JsonElement version : response) {
            JsonObject versionObject = version.getAsJsonObject();
            if (!versionObject.get("version_number").getAsString().equals(targetVersion)) continue;
            latestVersion = versionObject;
            break;
        }
        if (latestVersion != null) {
            JsonObject firstFile = latestVersion.get("files").getAsJsonArray().get(0).getAsJsonObject();
            String versionUrl = firstFile.get("url").getAsString();
            String versionFilename = firstFile.get("filename").getAsString();
            logger.accept("Found matching version: " + latestVersion.get("version_number").getAsString());
            Path filePath = FabricLoader.getInstance().getGameDir().resolve("mods").resolve(versionFilename);
            logger.accept("Downloading...");
            try (InputStream modStream = new URL(versionUrl).openStream();){
                Files.copy(modStream, filePath, StandardCopyOption.REPLACE_EXISTING);
            }
            logger.accept("Success!");
        } else {
            logger.accept("No matching version found");
        }
    }
}

