/*
 * Decompiled with CFR 0.152.
 */
package net.axay.fabrik.nbt.serialization.decoder;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.ExperimentalSerializationApi;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.encoding.AbstractDecoder;
import kotlinx.serialization.encoding.CompositeDecoder;
import kotlinx.serialization.modules.SerializersModule;
import net.axay.fabrik.nbt.serialization.Nbt;
import net.axay.fabrik.nbt.serialization.decoder.NbtByteArrayDecoder;
import net.axay.fabrik.nbt.serialization.decoder.NbtCompoundDecoder;
import net.axay.fabrik.nbt.serialization.decoder.NbtIntArrayDecoder;
import net.axay.fabrik.nbt.serialization.decoder.NbtListDecoder;
import net.axay.fabrik.nbt.serialization.decoder.NbtLongArrayDecoder;
import net.axay.fabrik.nbt.serialization.internal.ListLikeSerializationKt;
import net.minecraft.class_2479;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2494;
import net.minecraft.class_2495;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2501;
import net.minecraft.class_2503;
import net.minecraft.class_2516;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ExperimentalSerializationApi
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0016\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b'\u0018\u00002\u00020\u0001:\u00017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0012H\u0016J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\u001eH\u0016J\b\u0010#\u001a\u00020$H\u0002J\b\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020(H\u0002J\b\u0010)\u001a\u00020\u0014H\u0016J\n\u0010*\u001a\u0004\u0018\u00010+H\u0016J!\u0010,\u001a\u0002H-\"\u0004\b\u0000\u0010-2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002H-0/H\u0016\u00a2\u0006\u0002\u00100J\b\u00101\u001a\u000202H\u0016J\b\u00103\u001a\u000204H\u0016J\b\u00105\u001a\u00020\nH&J\b\u00106\u001a\u00020\nH\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u00068"}, d2={"Lnet/axay/fabrik/nbt/serialization/decoder/NbtTagDecoder;", "Lkotlinx/serialization/encoding/AbstractDecoder;", "nbt", "Lnet/axay/fabrik/nbt/serialization/Nbt;", "(Lnet/axay/fabrik/nbt/serialization/Nbt;)V", "getNbt", "()Lnet/axay/fabrik/nbt/serialization/Nbt;", "nextArrayType", "Lnet/axay/fabrik/nbt/serialization/decoder/NbtTagDecoder$NextArrayType;", "nextNullable", "Lnet/minecraft/nbt/NbtElement;", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "beginStructure", "Lkotlinx/serialization/encoding/CompositeDecoder;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "decodeBoolean", "", "decodeByte", "", "decodeByteArray", "", "decodeChar", "", "decodeDouble", "", "decodeEnum", "", "enumDescriptor", "decodeFloat", "", "decodeInt", "decodeIntArray", "", "decodeLong", "", "decodeLongArray", "", "decodeNotNullMark", "decodeNull", "", "decodeSerializableValue", "T", "deserializer", "Lkotlinx/serialization/DeserializationStrategy;", "(Lkotlinx/serialization/DeserializationStrategy;)Ljava/lang/Object;", "decodeShort", "", "decodeString", "", "next", "nextMaybeNullable", "NextArrayType", "fabrikmc-nbt"})
public abstract class NbtTagDecoder
extends AbstractDecoder {
    @NotNull
    private final Nbt nbt;
    @NotNull
    private final SerializersModule serializersModule;
    @NotNull
    private NextArrayType nextArrayType;
    @Nullable
    private class_2520 nextNullable;

    public NbtTagDecoder(@NotNull Nbt nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        this.nbt = nbt;
        this.serializersModule = this.nbt.getSerializersModule();
        this.nextArrayType = NextArrayType.None;
    }

    @NotNull
    protected final Nbt getNbt() {
        return this.nbt;
    }

    @NotNull
    public SerializersModule getSerializersModule() {
        return this.serializersModule;
    }

    @NotNull
    public abstract class_2520 next();

    public <T> T decodeSerializableValue(@NotNull DeserializationStrategy<T> deserializer) {
        Object object;
        Intrinsics.checkNotNullParameter(deserializer, (String)"deserializer");
        DeserializationStrategy<T> deserializationStrategy = deserializer;
        if (Intrinsics.areEqual(deserializationStrategy, ListLikeSerializationKt.getByteArraySerializer())) {
            object = this.decodeByteArray();
        } else if (Intrinsics.areEqual(deserializationStrategy, ListLikeSerializationKt.getIntArraySerializer())) {
            object = this.decodeIntArray();
        } else if (Intrinsics.areEqual(deserializationStrategy, ListLikeSerializationKt.getLongArraySerializer())) {
            object = this.decodeLongArray();
        } else {
            KSerializer<?> kSerializer = ListLikeSerializationKt.getElementSerializer(deserializer);
            this.nextArrayType = Intrinsics.areEqual(kSerializer, ListLikeSerializationKt.getByteSerializer()) ? NextArrayType.Byte : (Intrinsics.areEqual(kSerializer, ListLikeSerializationKt.getIntSerializer()) ? NextArrayType.Int : (Intrinsics.areEqual(kSerializer, ListLikeSerializationKt.getLongSerializer()) ? NextArrayType.Long : NextArrayType.None));
            object = super.decodeSerializableValue(deserializer);
        }
        return (T)object;
    }

    @NotNull
    public CompositeDecoder beginStructure(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return switch (WhenMappings.$EnumSwitchMapping$0[this.nextArrayType.ordinal()]) {
            case 1 -> (CompositeDecoder)new NbtByteArrayDecoder((class_2479)this.nextMaybeNullable());
            case 2 -> (CompositeDecoder)new NbtIntArrayDecoder((class_2495)this.nextMaybeNullable());
            case 3 -> (CompositeDecoder)new NbtLongArrayDecoder((class_2501)this.nextMaybeNullable());
            case 4 -> (CompositeDecoder)(Intrinsics.areEqual((Object)descriptor.getKind(), (Object)StructureKind.LIST.INSTANCE) ? (NbtTagDecoder)new NbtListDecoder(this.nbt, (class_2499)this.nextMaybeNullable()) : (NbtTagDecoder)new NbtCompoundDecoder(this.nbt, (class_2487)this.nextMaybeNullable()));
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public boolean decodeNotNullMark() {
        boolean bl;
        class_2499 it = (class_2499)this.next();
        boolean bl2 = false;
        if (it.isEmpty()) {
            bl = false;
        } else {
            this.nextNullable = it.method_10534(0);
            bl = true;
        }
        return bl;
    }

    @Nullable
    public Void decodeNull() {
        this.nextNullable = null;
        return null;
    }

    private final class_2520 nextMaybeNullable() {
        class_2520 class_25202 = this.nextNullable;
        if (class_25202 == null) {
            class_25202 = this.next();
        }
        class_2520 next = class_25202;
        this.nextNullable = null;
        return next;
    }

    public boolean decodeBoolean() {
        boolean bl;
        byte by = ((class_2481)this.nextMaybeNullable()).method_10698();
        if (by == 0) {
            bl = false;
        } else if (by == 1) {
            bl = true;
        } else {
            throw new SerializationException("Byte is not a valid boolean");
        }
        return bl;
    }

    public byte decodeByte() {
        return ((class_2481)this.nextMaybeNullable()).method_10698();
    }

    public short decodeShort() {
        return ((class_2516)this.nextMaybeNullable()).method_10696();
    }

    public char decodeChar() {
        return (char)((class_2497)this.nextMaybeNullable()).method_10701();
    }

    public int decodeInt() {
        return ((class_2497)this.nextMaybeNullable()).method_10701();
    }

    public long decodeLong() {
        return ((class_2503)this.nextMaybeNullable()).method_10699();
    }

    public float decodeFloat() {
        return ((class_2494)this.nextMaybeNullable()).method_10700();
    }

    public double decodeDouble() {
        return ((class_2489)this.nextMaybeNullable()).method_10697();
    }

    @NotNull
    public String decodeString() {
        String string = ((class_2519)this.nextMaybeNullable()).method_10714();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"nextMaybeNullable() as NbtString).asString()");
        return string;
    }

    public int decodeEnum(@NotNull SerialDescriptor enumDescriptor) {
        Intrinsics.checkNotNullParameter((Object)enumDescriptor, (String)"enumDescriptor");
        return enumDescriptor.getElementIndex(this.decodeString());
    }

    private final byte[] decodeByteArray() {
        byte[] byArray = ((class_2479)this.nextMaybeNullable()).method_10521();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"nextMaybeNullable() as NbtByteArray).byteArray");
        return byArray;
    }

    private final int[] decodeIntArray() {
        int[] nArray = ((class_2495)this.nextMaybeNullable()).method_10588();
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"nextMaybeNullable() as NbtIntArray).intArray");
        return nArray;
    }

    private final long[] decodeLongArray() {
        long[] lArray = ((class_2501)this.nextMaybeNullable()).method_10615();
        Intrinsics.checkNotNullExpressionValue((Object)lArray, (String)"nextMaybeNullable() as NbtLongArray).longArray");
        return lArray;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lnet/axay/fabrik/nbt/serialization/decoder/NbtTagDecoder$NextArrayType;", "", "(Ljava/lang/String;I)V", "Byte", "Int", "Long", "None", "fabrikmc-nbt"})
    private static final class NextArrayType
    extends Enum<NextArrayType> {
        public static final /* enum */ NextArrayType Byte = new NextArrayType();
        public static final /* enum */ NextArrayType Int = new NextArrayType();
        public static final /* enum */ NextArrayType Long = new NextArrayType();
        public static final /* enum */ NextArrayType None = new NextArrayType();
        private static final /* synthetic */ NextArrayType[] $VALUES;

        public static NextArrayType[] values() {
            return (NextArrayType[])$VALUES.clone();
        }

        public static NextArrayType valueOf(String value) {
            return Enum.valueOf(NextArrayType.class, value);
        }

        static {
            $VALUES = nextArrayTypeArray = new NextArrayType[]{NextArrayType.Byte, NextArrayType.Int, NextArrayType.Long, NextArrayType.None};
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NextArrayType.values().length];
            nArray[NextArrayType.Byte.ordinal()] = 1;
            nArray[NextArrayType.Int.ordinal()] = 2;
            nArray[NextArrayType.Long.ordinal()] = 3;
            nArray[NextArrayType.None.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

