/*
 * Decompiled with CFR 0.152.
 */
package fr.catcore.server.translations.api;

import com.google.common.collect.Multimap;
import fr.catcore.server.translations.api.LocalizationTarget;
import fr.catcore.server.translations.api.resource.language.LanguageReader;
import fr.catcore.server.translations.api.resource.language.ServerLanguage;
import fr.catcore.server.translations.api.resource.language.ServerLanguageDefinition;
import fr.catcore.server.translations.api.resource.language.TranslationAccess;
import fr.catcore.server.translations.api.resource.language.TranslationMap;
import fr.catcore.server.translations.api.resource.language.TranslationStore;
import fr.catcore.server.translations.api.resource.language.TranslationsReloadListener;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectRBTreeMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2588;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3695;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ServerTranslations
implements class_3302 {
    public static final String ID = "server_translations_api";
    public static final Logger LOGGER = LogManager.getLogger(ServerTranslations.class);
    public static final ServerTranslations INSTANCE = new ServerTranslations();
    private final SortedMap<String, ServerLanguageDefinition> supportedLanguages = new Object2ObjectRBTreeMap();
    private final TranslationStore translations = new TranslationStore();
    private final Map<String, ServerLanguage> languages = new Object2ObjectOpenHashMap();
    private TranslationMap vanillaTranslations;
    private ServerLanguage defaultLanguage;
    private ServerLanguage systemLanguage;
    private final List<TranslationsReloadListener> reloadListeners = new ArrayList<TranslationsReloadListener>();

    private ServerTranslations() {
        this.loadSupportedLanguages();
        this.reload();
    }

    private void loadSupportedLanguages() {
        try {
            List<ServerLanguageDefinition> definitions = ServerLanguageDefinition.loadLanguageDefinitions();
            for (ServerLanguageDefinition language : definitions) {
                this.supportedLanguages.put(language.code(), language);
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to load server language definitions", (Throwable)e);
        }
    }

    private void reload() {
        this.translations.clear();
        this.languages.clear();
        this.vanillaTranslations = LanguageReader.loadVanillaTranslations();
        this.translations.add("en_us", () -> this.vanillaTranslations);
        this.defaultLanguage = this.createLanguage(ServerLanguageDefinition.DEFAULT);
        if (this.systemLanguage != null) {
            this.setSystemLanguage(this.systemLanguage.definition());
        } else {
            this.setSystemLanguage(ServerLanguageDefinition.DEFAULT);
        }
        this.reloadListeners.forEach(TranslationsReloadListener::reload);
    }

    public void addTranslations(String code, Supplier<TranslationMap> supplier) {
        this.translations.add(code, supplier);
    }

    @NotNull
    public ServerLanguage getLanguage(@Nullable LocalizationTarget target) {
        return this.getLanguage(target != null ? target.getLanguageCode() : null);
    }

    @NotNull
    public ServerLanguage getLanguage(@Nullable String code) {
        if (code == null) {
            return this.defaultLanguage;
        }
        ServerLanguage language = this.languages.get(code);
        if (language != null) {
            return language;
        }
        ServerLanguageDefinition definition = (ServerLanguageDefinition)this.supportedLanguages.get(code);
        if (definition != null) {
            return this.createLanguage(definition);
        }
        return this.defaultLanguage;
    }

    @NotNull
    public ServerLanguageDefinition getLanguageDefinition(@Nullable String code) {
        if (code == null) {
            return ServerLanguageDefinition.DEFAULT;
        }
        return this.supportedLanguages.getOrDefault(code, ServerLanguageDefinition.DEFAULT);
    }

    private ServerLanguage createLanguage(ServerLanguageDefinition definition) {
        TranslationMap translations = this.translations.get(definition.code());
        TranslationMap defaultTranslations = this.translations.get("en_us");
        TranslationAccess remote = translations.union(defaultTranslations);
        TranslationAccess local = remote.subtract(this.vanillaTranslations);
        boolean isClient = FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT;
        ServerLanguage language = new ServerLanguage(definition, isClient ? local : remote, isClient ? remote : local);
        this.languages.put(definition.code(), language);
        return language;
    }

    public void setSystemLanguage(ServerLanguageDefinition definition) {
        this.systemLanguage = Objects.requireNonNull(this.getLanguage(definition.code()));
    }

    @NotNull
    public ServerLanguage getSystemLanguage() {
        return this.systemLanguage;
    }

    @NotNull
    public ServerLanguage getDefaultLanguage() {
        return this.defaultLanguage;
    }

    public Iterable<ServerLanguageDefinition> getAllLanguages() {
        return this.supportedLanguages.values();
    }

    public void registerReloadListener(TranslationsReloadListener reloadListener) {
        this.reloadListeners.add(reloadListener);
    }

    private int getTranslationKeyCount() {
        return this.translations.get(this.systemLanguage.definition().code()).size();
    }

    public CompletableFuture<Void> method_25931(class_3302.class_4045 synchronizer, class_3300 manager, class_3695 prepareProfiler, class_3695 applyProfiler, Executor prepareExecutor, Executor applyExecutor) {
        CompletableFuture<Multimap> future = CompletableFuture.supplyAsync(() -> {
            this.reload();
            return LanguageReader.collectTranslationSuppliers(manager);
        });
        return ((CompletableFuture)future.thenCompose(arg_0 -> ((class_3302.class_4045)synchronizer).method_18352(arg_0))).thenAcceptAsync(v -> {
            Multimap languageSuppliers = (Multimap)future.join();
            languageSuppliers.forEach(this.translations::add);
            int keyCount = INSTANCE.getTranslationKeyCount();
            LOGGER.info(new class_2588("text.translated_server.loaded.translation_key", new Object[]{String.valueOf(keyCount)}).getString());
        });
    }

    public String method_22322() {
        return super.method_22322();
    }
}

