/*
 * Decompiled with CFR 0.152.
 */
package fr.catcore.server.translations.api.mixin.text;

import fr.catcore.server.translations.api.LocalizationTarget;
import fr.catcore.server.translations.api.ServerTranslations;
import fr.catcore.server.translations.api.resource.language.TranslationAccess;
import fr.catcore.server.translations.api.text.LocalizableText;
import fr.catcore.server.translations.api.text.LocalizedTextVisitor;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_2583;
import net.minecraft.class_2588;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={class_2588.class})
public abstract class TranslatableTextMixin
implements LocalizableText,
class_5250 {
    @Shadow
    @Final
    private static Pattern field_11872;
    @Shadow
    @Final
    private static class_5348 field_24368;
    @Shadow
    @Final
    private String field_11876;
    @Shadow
    @Final
    private Object[] field_11875;

    @Shadow
    protected abstract class_5348 method_29434(int var1);

    @Shadow
    public abstract class_2588 method_11020();

    @Nullable
    private List<class_5348> buildTranslations(@Nullable LocalizationTarget target) {
        TranslationAccess translations = this.getTranslationsFor(target);
        String translation = translations.getOrNull(this.field_11876);
        if (translation == null) {
            return null;
        }
        ArrayList<class_5348> result = new ArrayList<class_5348>();
        Matcher argumentMatcher = field_11872.matcher(translation);
        int currentCharIndex = 0;
        int currentArgumentIndex = 0;
        while (argumentMatcher.find(currentCharIndex)) {
            int argumentStart = argumentMatcher.start();
            int argumentEnd = argumentMatcher.end();
            if (argumentStart > currentCharIndex) {
                String literal = translation.substring(currentCharIndex, argumentStart);
                if (literal.indexOf(37) != -1) {
                    return null;
                }
                result.add(class_5348.method_29430((String)literal));
            }
            String formatType = argumentMatcher.group(2);
            String literal = translation.substring(argumentStart, argumentEnd);
            if ("%".equals(formatType) && "%%".equals(literal)) {
                result.add(field_24368);
            } else {
                int argumentIndex;
                if (!"s".equals(formatType)) {
                    return null;
                }
                String matchedArgumentIndex = argumentMatcher.group(1);
                int n = argumentIndex = matchedArgumentIndex != null ? Integer.parseInt(matchedArgumentIndex) - 1 : currentArgumentIndex++;
                if (argumentIndex < this.field_11875.length) {
                    result.add(this.method_29434(argumentIndex));
                }
            }
            currentCharIndex = argumentEnd;
        }
        if (currentCharIndex < translation.length()) {
            String remaining = translation.substring(currentCharIndex);
            if (remaining.indexOf(37) != -1) {
                return null;
            }
            result.add(class_5348.method_29430((String)remaining));
        }
        return result;
    }

    private TranslationAccess getTranslationsFor(@Nullable LocalizationTarget target) {
        if (target != null) {
            return target.getLanguage().remote();
        }
        return ServerTranslations.INSTANCE.getSystemLanguage().local();
    }

    @Override
    public void visitSelfLocalized(LocalizedTextVisitor visitor, LocalizationTarget target, class_2583 style) {
        List<class_5348> translations = this.buildTranslations(target);
        if (translations != null) {
            this.visitSelfTranslated(visitor, target, style, translations);
        } else {
            this.visitSelfUntranslated(visitor, style);
        }
    }

    private void visitSelfTranslated(LocalizedTextVisitor visitor, LocalizationTarget target, class_2583 style, List<class_5348> translations) {
        visitor.acceptLiteral("", style);
        for (class_5348 translation : translations) {
            class_5348 class_53482 = translation;
            if (class_53482 instanceof LocalizableText) {
                LocalizableText localizableText = (LocalizableText)class_53482;
                localizableText.visitLocalized(visitor, target, style);
                continue;
            }
            translation.method_27657(visitor.asGeneric(style));
        }
    }

    private void visitSelfUntranslated(LocalizedTextVisitor visitor, class_2583 style) {
        visitor.accept(this.method_11020().method_10862(style));
    }
}

