/*
 * Decompiled with CFR 0.152.
 */
package fr.catcore.server.translations.api.nbt;

import java.util.Objects;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import org.jetbrains.annotations.Nullable;

public final class NbtLocalizer {
    private static final String EMPTY_STRING = "server_translations_api:empty";
    private static final class_2519 EMPTY_NbtElement = class_2519.method_23256((String)"server_translations_api:empty");
    private final class_2487 nbtElement;
    private boolean copiedNbtElement;
    private class_2487 result;
    private class_2487 revert;

    public NbtLocalizer(class_2487 nbtElement) {
        this.nbtElement = nbtElement;
    }

    public static void applyRevert(class_2487 nbtElement, class_2487 revert) {
        for (String key : revert.method_10541()) {
            class_2520 revertNbtElement = Objects.requireNonNull(revert.method_10580(key));
            if (!NbtLocalizer.isEmptyNbtElement(revertNbtElement)) {
                nbtElement.method_10566(key, revertNbtElement);
                continue;
            }
            nbtElement.method_10551(key);
        }
    }

    private static boolean isEmptyNbtElement(class_2520 nbtElement) {
        return nbtElement.method_10711() == 8 && nbtElement.method_10714().equals(EMPTY_STRING);
    }

    public void set(String key, class_2520 nbtElement) {
        class_2487 result = this.getOrCreateResultNbtElement();
        class_2520 previous = result.method_10566(key, nbtElement);
        if (!Objects.equals(nbtElement, previous)) {
            this.trackSet(key, previous);
        }
    }

    public class_2487 getCompound(String key) {
        class_2487 result = this.getResultNbtElement();
        return result != null ? result.method_10562(key) : new class_2487();
    }

    public class_2499 getList(String key, int type) {
        class_2487 result = this.getResultNbtElement();
        return result != null ? result.method_10554(key, type) : new class_2499();
    }

    public boolean contains(String key, int type) {
        if (this.result != null) {
            return this.result.method_10573(key, type);
        }
        if (this.nbtElement != null) {
            return this.nbtElement.method_10573(key, type);
        }
        return false;
    }

    private void trackSet(String key, class_2520 previous) {
        class_2487 revert = this.revert;
        if (revert == null) {
            this.revert = revert = new class_2487();
        }
        if (!revert.method_10545(key)) {
            if (previous != null) {
                revert.method_10566(key, previous);
            } else {
                revert.method_10566(key, (class_2520)EMPTY_NbtElement);
            }
        }
    }

    private class_2487 getOrCreateResultNbtElement() {
        class_2487 result = this.getResultNbtElement();
        if (result == null) {
            this.result = result = new class_2487();
        }
        return result;
    }

    @Nullable
    public class_2487 getResultNbtElement() {
        if (!this.copiedNbtElement) {
            this.result = this.nbtElement != null ? this.nbtElement.method_10553() : null;
            this.copiedNbtElement = true;
        }
        return this.result;
    }

    @Nullable
    public class_2487 getRevertNbtElement() {
        return this.revert;
    }
}

