/*
 * Decompiled with CFR 0.152.
 */
package fr.catcore.server.translations.api;

import com.google.common.collect.Multimap;
import com.mojang.logging.LogUtils;
import fr.catcore.server.translations.api.LocalizationTarget;
import fr.catcore.server.translations.api.resource.language.LanguageReader;
import fr.catcore.server.translations.api.resource.language.ServerLanguage;
import fr.catcore.server.translations.api.resource.language.ServerLanguageDefinition;
import fr.catcore.server.translations.api.resource.language.TranslationAccess;
import fr.catcore.server.translations.api.resource.language.TranslationMap;
import fr.catcore.server.translations.api.resource.language.TranslationStore;
import fr.catcore.server.translations.api.resource.language.TranslationsReloadListener;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectRBTreeMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3545;
import net.minecraft.class_3695;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public final class ServerTranslations
implements IdentifiableResourceReloadListener,
ModInitializer {
    public static final String ID = "server_translations_api";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final ServerTranslations INSTANCE = new ServerTranslations();
    private final SortedMap<String, ServerLanguageDefinition> supportedLanguages = new Object2ObjectRBTreeMap();
    private final TranslationStore translations = new TranslationStore();
    private final Map<String, ServerLanguage> languages = new Object2ObjectOpenHashMap();
    private TranslationMap vanillaTranslations;
    private ServerLanguage defaultLanguage;
    private ServerLanguage systemLanguage;
    private final List<TranslationsReloadListener> reloadListeners = new ArrayList<TranslationsReloadListener>();
    private final Map<String, String> CODE_ALIAS = new HashMap<String, String>();

    private ServerTranslations() {
        this.loadSupportedLanguages();
        this.reload();
    }

    private void loadSupportedLanguages() {
        try {
            class_3545<List<ServerLanguageDefinition>, Map<String, String>> pair = ServerLanguageDefinition.loadLanguageDefinitions();
            List definitions = (List)pair.method_15442();
            for (ServerLanguageDefinition language : definitions) {
                this.supportedLanguages.put(language.code(), language);
            }
            this.CODE_ALIAS.putAll((Map)pair.method_15441());
        }
        catch (IOException e) {
            LOGGER.error("Failed to load server language definitions", (Throwable)e);
        }
    }

    private void reload() {
        this.translations.clear();
        this.languages.clear();
        this.vanillaTranslations = LanguageReader.loadVanillaTranslations();
        this.translations.add("en_us", () -> this.vanillaTranslations);
        this.defaultLanguage = this.createLanguage(ServerLanguageDefinition.DEFAULT);
        if (this.systemLanguage != null) {
            this.setSystemLanguage(this.systemLanguage.definition());
        } else {
            this.setSystemLanguage(ServerLanguageDefinition.DEFAULT);
        }
        this.reloadListeners.forEach(TranslationsReloadListener::reload);
    }

    public void addTranslations(String code, Supplier<TranslationMap> supplier) {
        this.translations.add(code, supplier);
    }

    @NotNull
    public ServerLanguage getLanguage(@Nullable LocalizationTarget target) {
        return this.getLanguage(target != null ? target.getLanguageCode() : null);
    }

    @NotNull
    public ServerLanguage getLanguage(@Nullable String code) {
        if (code == null) {
            return this.defaultLanguage;
        }
        ServerLanguage language = this.languages.get(code);
        if (language != null) {
            return language;
        }
        ServerLanguageDefinition definition = (ServerLanguageDefinition)this.supportedLanguages.get(code);
        if (definition != null) {
            return this.createLanguage(definition);
        }
        return this.defaultLanguage;
    }

    @NotNull
    public ServerLanguageDefinition getLanguageDefinition(@Nullable String code) {
        if (code == null) {
            return ServerLanguageDefinition.DEFAULT;
        }
        return this.supportedLanguages.getOrDefault(code, ServerLanguageDefinition.DEFAULT);
    }

    private ServerLanguage createLanguage(ServerLanguageDefinition definition) {
        TranslationMap translations = this.translations.get(definition.code());
        TranslationMap defaultTranslations = this.translations.get("en_us");
        TranslationAccess remote = translations.union(defaultTranslations);
        TranslationAccess local = remote.subtract(this.vanillaTranslations);
        boolean isClient = FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT;
        ServerLanguage language = new ServerLanguage(definition, isClient ? local : remote, isClient ? remote : local);
        this.languages.put(definition.code(), language);
        return language;
    }

    public void setSystemLanguage(ServerLanguageDefinition definition) {
        this.systemLanguage = Objects.requireNonNull(this.getLanguage(definition.code()));
    }

    @NotNull
    public ServerLanguage getSystemLanguage() {
        return this.systemLanguage;
    }

    @NotNull
    public ServerLanguage getDefaultLanguage() {
        return this.defaultLanguage;
    }

    public Iterable<ServerLanguageDefinition> getAllLanguages() {
        return this.supportedLanguages.values();
    }

    public void registerReloadListener(TranslationsReloadListener reloadListener) {
        this.reloadListeners.add(reloadListener);
    }

    private int getTranslationKeyCount() {
        return this.translations.get(this.systemLanguage.definition().code()).size();
    }

    public CompletableFuture<Void> method_25931(class_3302.class_4045 synchronizer, class_3300 manager, class_3695 prepareProfiler, class_3695 applyProfiler, Executor prepareExecutor, Executor applyExecutor) {
        CompletableFuture<Multimap> future = CompletableFuture.supplyAsync(() -> {
            this.reload();
            return LanguageReader.collectTranslationSuppliers(manager);
        });
        return ((CompletableFuture)future.thenCompose(arg_0 -> ((class_3302.class_4045)synchronizer).method_18352(arg_0))).thenAcceptAsync(v -> {
            Multimap languageSuppliers = (Multimap)future.join();
            languageSuppliers.forEach(this.translations::add);
            int keyCount = INSTANCE.getTranslationKeyCount();
            LOGGER.info(class_2561.method_43469((String)"text.translated_server.loaded.translation_key", (Object[])new Object[]{String.valueOf(keyCount)}).getString());
        });
    }

    public String method_22322() {
        return super.method_22322();
    }

    public String getCodeAlias(String code) {
        return this.CODE_ALIAS.getOrDefault(code, code);
    }

    public void onInitialize() {
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)INSTANCE);
    }

    public class_2960 getFabricId() {
        return new class_2960(ID, "translations");
    }
}

