/*
 * Decompiled with CFR 0.152.
 */
package fr.catcore.server.translations.api.nbt;

import fr.catcore.server.translations.api.LocalizationTarget;
import fr.catcore.server.translations.api.nbt.NbtLocalizer;
import fr.catcore.server.translations.api.text.LocalizableText;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public final class StackNbtLocalizer {
    private static final String TRANSLATED_TAG = "server_translated";

    public static class_2487 localize(class_1799 stack, class_2487 tag, LocalizationTarget target) {
        if (tag == null) {
            return null;
        }
        try {
            NbtLocalizer nbt = new NbtLocalizer(tag);
            StackNbtLocalizer.translateDisplay(target, nbt);
            StackNbtLocalizer.translateBook(target, nbt);
            class_2487 revertTag = nbt.getRevertNbtElement();
            if (revertTag != null) {
                tag.method_10566(TRANSLATED_TAG, (class_2520)revertTag);
            }
            return nbt.getResultNbtElement();
        }
        catch (Exception e) {
            return tag;
        }
    }

    public static class_2487 unlocalize(class_2487 tag) {
        if (tag != null && tag.method_10573(TRANSLATED_TAG, 10)) {
            class_2487 revert = tag.method_10562(TRANSLATED_TAG);
            NbtLocalizer.applyRevert(tag, revert);
            tag.method_10551(TRANSLATED_TAG);
        }
        return tag;
    }

    private static void translateDisplay(LocalizationTarget target, NbtLocalizer nbt) {
        if (nbt.contains("display", 10)) {
            class_2487 display = nbt.getCompound("display");
            StackNbtLocalizer.translateCustomName(display, target);
            StackNbtLocalizer.translateLore(display, target);
            nbt.set("display", (class_2520)display);
        }
    }

    private static void translateBook(LocalizationTarget target, NbtLocalizer nbt) {
        if (nbt.contains("pages", 9)) {
            class_2499 pages = nbt.getList("pages", 8);
            for (int i = 0; i < pages.size(); ++i) {
                String pageJson = pages.method_10608(i);
                pageJson = StackNbtLocalizer.localizeTextJson(pageJson, target);
                pages.method_10535(i, (class_2520)class_2519.method_23256((String)pageJson));
            }
            nbt.set("pages", (class_2520)pages);
        }
    }

    private static void translateCustomName(class_2487 display, LocalizationTarget target) {
        if (display.method_10573("Name", 8)) {
            display.method_10582("Name", StackNbtLocalizer.localizeTextJson(display.method_10558("Name"), target));
        }
    }

    private static void translateLore(class_2487 display, LocalizationTarget target) {
        if (display.method_10573("Lore", 9)) {
            class_2499 loreList = display.method_10554("Lore", 8);
            for (int i = 0; i < loreList.size(); ++i) {
                loreList.method_10535(i, (class_2520)class_2519.method_23256((String)StackNbtLocalizer.localizeTextJson(loreList.method_10608(i), target)));
            }
        }
    }

    private static String localizeTextJson(String json, LocalizationTarget target) {
        class_5250 text;
        try {
            text = class_2561.class_2562.method_10873((String)json);
        }
        catch (Exception e) {
            text = null;
        }
        if (text == null) {
            return json;
        }
        class_2561 localized = LocalizableText.asLocalizedFor((class_2561)text, target);
        if (!localized.equals(text)) {
            return class_2561.class_2562.method_10867((class_2561)localized);
        }
        return json;
    }
}

