/*
 * Decompiled with CFR 0.152.
 */
package fr.catcore.server.translations.api.resource.language;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import fr.catcore.server.translations.api.ServerTranslations;
import fr.catcore.server.translations.api.resource.language.TranslationMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.function.Supplier;
import net.minecraft.class_2477;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;

public final class LanguageReader {
    public static TranslationMap read(InputStream stream) {
        TranslationMap map = new TranslationMap();
        class_2477.method_29425((InputStream)stream, map::put);
        return map;
    }

    public static TranslationMap readLegacy(InputStream input) {
        TranslationMap map = new TranslationMap();
        BufferedReader reader = new BufferedReader(new InputStreamReader(input));
        reader.lines().forEach(line -> {
            if (line.startsWith("\n") || line.startsWith("#") || line.startsWith("/")) {
                return;
            }
            String key = line.split("=")[0];
            int values = line.split("=").length;
            StringBuilder value = new StringBuilder();
            for (int i = 1; i < values; ++i) {
                value.append(line.split("=")[i]);
            }
            map.put(key, value.toString());
        });
        return map;
    }

    public static TranslationMap loadVanillaTranslations() {
        TranslationMap translationMap;
        block8: {
            InputStream input = class_2477.class.getResourceAsStream("/assets/minecraft/lang/en_us.json");
            try {
                translationMap = LanguageReader.read(input);
                if (input == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    ServerTranslations.LOGGER.warn("Failed to load default language", (Throwable)e);
                    return new TranslationMap();
                }
            }
            input.close();
        }
        return translationMap;
    }

    public static Multimap<String, Supplier<TranslationMap>> collectTranslationSuppliers(class_3300 manager) {
        HashMultimap translationSuppliers = HashMultimap.create();
        for (class_2960 path2 : manager.method_14488("lang", path -> path.method_12832().endsWith(".json")).keySet()) {
            String code = LanguageReader.getLanguageCodeForPath(path2);
            translationSuppliers.put((Object)code, () -> {
                TranslationMap map = new TranslationMap();
                try {
                    for (class_3298 resource : manager.method_14489(path2)) {
                        map.putAll(LanguageReader.read(resource.method_14482()));
                    }
                }
                catch (IOException | RuntimeException e) {
                    ServerTranslations.LOGGER.warn("Failed to load language resource at {}", (Object)path2, (Object)e);
                }
                return map;
            });
        }
        return translationSuppliers;
    }

    private static String getLanguageCodeForPath(class_2960 file) {
        String path = file.method_12832();
        path = path.substring("lang".length() + 1, path.length() - ".json".length());
        return ServerTranslations.INSTANCE.getCodeAlias(path);
    }
}

