/*
 * Decompiled with CFR 0.152.
 */
package fr.catcore.server.translations.api.resource.language;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import fr.catcore.server.translations.api.ServerTranslations;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.class_3545;

public record ServerLanguageDefinition(String code, String region, String name, boolean rightToLeft) implements Comparable<ServerLanguageDefinition>
{
    public static final String DEFAULT_CODE = "en_us";
    public static final ServerLanguageDefinition DEFAULT = new ServerLanguageDefinition("en_us", "US", "English", false);

    public static class_3545<List<ServerLanguageDefinition>, Map<String, String>> loadLanguageDefinitions() throws IOException {
        ArrayList<ServerLanguageDefinition> languageDefinitions = new ArrayList<ServerLanguageDefinition>();
        HashMap<String, String> aliasList = new HashMap<String, String>();
        try (BufferedReader read = new BufferedReader(new InputStreamReader(ServerTranslations.class.getResourceAsStream("/minecraft_languages.json")));){
            JsonObject root = JsonParser.parseReader((Reader)read).getAsJsonObject();
            JsonObject languageRoot = root.getAsJsonObject("language");
            for (Map.Entry entry : languageRoot.entrySet()) {
                ServerLanguageDefinition definition = ServerLanguageDefinition.parse((String)entry.getKey(), (JsonObject)entry.getValue());
                languageDefinitions.add(definition);
            }
            JsonObject aliasRoot = root.getAsJsonObject("alias");
            for (Map.Entry entry : aliasRoot.entrySet()) {
                aliasList.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
            }
        }
        return new class_3545(languageDefinitions, aliasList);
    }

    public static ServerLanguageDefinition parse(String code, JsonObject jsonObject) {
        String region = jsonObject.get("region").getAsString();
        String name = jsonObject.get("name").getAsString();
        boolean bidirectional = jsonObject.get("bidirectional").getAsBoolean();
        return new ServerLanguageDefinition(code.toLowerCase(Locale.ROOT), region, name, bidirectional);
    }

    @Override
    public String toString() {
        return String.format("%s (%s)", this.region, this.name);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ServerLanguageDefinition)) return false;
        ServerLanguageDefinition languageDefinition = (ServerLanguageDefinition)o;
        if (!this.code.equals(languageDefinition.code)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return this.code.hashCode();
    }

    @Override
    public int compareTo(ServerLanguageDefinition languageDefinition) {
        return this.code.compareTo(languageDefinition.code);
    }
}

