/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.gui.entries;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import me.shedaniel.clothconfig2.gui.entries.BaseListCell;
import me.shedaniel.clothconfig2.gui.entries.BaseListEntry;
import net.minecraft.class_1074;
import net.minecraft.class_310;
import net.minecraft.class_342;
import net.minecraft.class_364;

public class IntegerListListEntry
extends BaseListEntry<Integer, IntegerListCell> {
    private int minimum = -2147483647;
    private int maximum = Integer.MAX_VALUE;
    private Function<Integer, Optional<String>> cellErrorSupplier;

    @Deprecated
    public IntegerListListEntry(String fieldName, List<Integer> value, boolean defaultExpended, Supplier<Optional<String[]>> tooltipSupplier, Consumer<List<Integer>> saveConsumer, Supplier<List<Integer>> defaultValue, String resetButtonKey) {
        this(fieldName, value, defaultExpended, tooltipSupplier, saveConsumer, defaultValue, resetButtonKey, false);
    }

    @Deprecated
    public IntegerListListEntry(String fieldName, List<Integer> value, boolean defaultExpended, Supplier<Optional<String[]>> tooltipSupplier, Consumer<List<Integer>> saveConsumer, Supplier<List<Integer>> defaultValue, String resetButtonKey, boolean requiresRestart) {
        super(fieldName, tooltipSupplier, defaultValue, (BaseListEntry baseListEntry) -> new IntegerListCell(0, (IntegerListListEntry)((Object)baseListEntry)), saveConsumer, resetButtonKey, requiresRestart);
        for (int integer : value) {
            this.cells.add(new IntegerListCell(integer, this));
        }
        this.widgets.addAll(this.cells);
        this.expended = defaultExpended;
    }

    public Function<Integer, Optional<String>> getCellErrorSupplier() {
        return this.cellErrorSupplier;
    }

    public void setCellErrorSupplier(Function<Integer, Optional<String>> cellErrorSupplier) {
        this.cellErrorSupplier = cellErrorSupplier;
    }

    @Override
    public List<Integer> getValue() {
        return this.cells.stream().map(IntegerListCell::getValue).collect(Collectors.toList());
    }

    public IntegerListListEntry setMaximum(int maximum) {
        this.maximum = maximum;
        return this;
    }

    public IntegerListListEntry setMinimum(int minimum) {
        this.minimum = minimum;
        return this;
    }

    @Override
    protected IntegerListCell getFromValue(Integer value) {
        return new IntegerListCell(value, this);
    }

    public static class IntegerListCell
    extends BaseListCell {
        private Function<String, String> stripCharacters = s -> {
            StringBuilder stringBuilder_1 = new StringBuilder();
            char[] var2 = s.toCharArray();
            int var3 = var2.length;
            for (int var4 = 0; var4 < var3; ++var4) {
                if (!Character.isDigit(var2[var4]) && var2[var4] != '-') continue;
                stringBuilder_1.append(var2[var4]);
            }
            return stringBuilder_1.toString();
        };
        private class_342 widget;
        private boolean isSelected;
        private IntegerListListEntry listListEntry;

        public IntegerListCell(int value, IntegerListListEntry listListEntry) {
            this.listListEntry = listListEntry;
            this.setErrorSupplier(() -> listListEntry.cellErrorSupplier == null ? Optional.empty() : listListEntry.getCellErrorSupplier().apply(this.getValue()));
            this.widget = new class_342(class_310.method_1551().field_1772, 0, 0, 100, 18, ""){

                public void render(int int_1, int int_2, float float_1) {
                    boolean f = this.isFocused();
                    this.setFocused(isSelected);
                    widget.method_1868(this.getPreferredTextColor());
                    super.render(int_1, int_2, float_1);
                    this.setFocused(f);
                }

                public void method_1867(String string_1) {
                    super.method_1867((String)stripCharacters.apply(string_1));
                }
            };
            this.widget.method_1880(999999);
            this.widget.method_1858(false);
            this.widget.method_1852(value + "");
            this.widget.method_1863(s -> {
                if (!(value + "").equalsIgnoreCase((String)s)) {
                    listListEntry.getScreen().setEdited(true, listListEntry.isRequiresRestart());
                }
            });
        }

        public int getValue() {
            try {
                return Integer.valueOf(this.widget.method_1882());
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }

        @Override
        public Optional<String> getError() {
            try {
                int i = Integer.valueOf(this.widget.method_1882());
                if (i > this.listListEntry.maximum) {
                    return Optional.of(class_1074.method_4662((String)"text.cloth-config.error.too_large", (Object[])new Object[]{this.listListEntry.maximum}));
                }
                if (i < this.listListEntry.minimum) {
                    return Optional.of(class_1074.method_4662((String)"text.cloth-config.error.too_small", (Object[])new Object[]{this.listListEntry.minimum}));
                }
            }
            catch (NumberFormatException ex) {
                return Optional.of(class_1074.method_4662((String)"text.cloth-config.error.not_valid_number_int", (Object[])new Object[0]));
            }
            return Optional.empty();
        }

        @Override
        public int getCellHeight() {
            return 20;
        }

        @Override
        public void render(int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            this.widget.setWidth(entryWidth - 12);
            this.widget.x = x;
            this.widget.y = y + 1;
            this.widget.method_1888(this.listListEntry.isEditable());
            this.isSelected = isSelected;
            this.widget.render(mouseX, mouseY, delta);
            if (isSelected && this.listListEntry.isEditable()) {
                IntegerListCell.fill((int)x, (int)(y + 12), (int)(x + entryWidth - 12), (int)(y + 13), (int)(this.getConfigError().isPresent() ? -43691 : -2039584));
            }
        }

        public List<? extends class_364> children() {
            return Collections.singletonList(this.widget);
        }
    }
}

