/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.apathy;

import agency.highlysuspect.apathy.JsonRule;
import agency.highlysuspect.apathy.config.BossConfig;
import agency.highlysuspect.apathy.config.Config;
import agency.highlysuspect.apathy.config.GeneralConfig;
import agency.highlysuspect.apathy.config.MobConfig;
import agency.highlysuspect.apathy.platform.PlatformSupport;
import agency.highlysuspect.apathy.rule.spec.Specs;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Apathy {
    public static final String MODID = "apathy";
    public static final Logger LOG = LogManager.getLogger((String)"apathy");
    public static final Path CONFIG_FOLDER = PlatformSupport.instance.getConfigPath();
    public static MobConfig mobConfig;
    public static GeneralConfig generalConfig;
    public static BossConfig bossConfig;

    public static ResourceLocation id(String path) {
        return new ResourceLocation(MODID, path);
    }

    public static void init() {
        try {
            Files.createDirectories(CONFIG_FOLDER, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Problem creating config/apathy/ subdirectory", e);
        }
        Specs.onInitialize();
        Apathy.loadConfig();
        PlatformSupport.instance.initialize();
    }

    public static void loadConfig() {
        GeneralConfig oldGeneralConfig = generalConfig;
        MobConfig oldMobConfig = mobConfig;
        BossConfig oldBossConfig = bossConfig;
        try {
            generalConfig = Config.read(new GeneralConfig(), CONFIG_FOLDER.resolve("general.cfg"));
            mobConfig = Config.read(new MobConfig(), CONFIG_FOLDER.resolve("mobs.cfg"));
            bossConfig = Config.read(new BossConfig(), CONFIG_FOLDER.resolve("boss.cfg"));
            JsonRule.loadJson();
        }
        catch (Exception e) {
            if (oldGeneralConfig == null && oldMobConfig == null && oldBossConfig == null) {
                throw new RuntimeException("Problem initializing config file.", e);
            }
            generalConfig = oldGeneralConfig;
            mobConfig = oldMobConfig;
            bossConfig = oldBossConfig;
            LOG.error("Problem reloading config file: ", (Throwable)e);
            LOG.error("The current config has not been changed. Resolve the error, and try loading the config file again.");
        }
    }
}

