/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.apathy;

import agency.highlysuspect.apathy.Apathy;
import agency.highlysuspect.apathy.rule.Rule;
import agency.highlysuspect.apathy.rule.spec.RuleSpec;
import agency.highlysuspect.apathy.rule.spec.Specs;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;

public class JsonRule {
    public static Rule jsonRule;
    public static final Path MOBS_JSON;
    public static final Path DUMP_DIR;
    public static final Gson GSON;

    public static void loadJson() {
        JsonElement json;
        String stuff;
        if (!Files.exists(MOBS_JSON, new LinkOption[0])) {
            jsonRule = null;
            return;
        }
        try {
            stuff = Files.lines(MOBS_JSON).collect(Collectors.joining("\n"));
        }
        catch (IOException e) {
            Apathy.LOG.error("Problem loading json rule at " + MOBS_JSON, (Throwable)e);
            return;
        }
        try {
            json = (JsonElement)GSON.fromJson(stuff, JsonElement.class);
        }
        catch (JsonParseException e) {
            Apathy.LOG.error("Problem parsing json rule at " + MOBS_JSON, (Throwable)e);
            return;
        }
        DataResult ruleSpecResult = Specs.RULE_SPEC_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json);
        if (ruleSpecResult.error().isPresent()) {
            Apathy.LOG.error("Problem decoding json rule: " + ((DataResult.PartialResult)ruleSpecResult.error().get()).message());
            return;
        }
        RuleSpec spec = (RuleSpec)ruleSpecResult.getOrThrow(false, arg_0 -> ((Logger)Apathy.LOG).error(arg_0));
        try {
            if (Apathy.generalConfig.debugJsonRule) {
                JsonRule.dumpSpec("json-rule", spec);
            }
            if (Apathy.generalConfig.runRuleOptimizer) {
                spec = spec.optimize();
                if (Apathy.generalConfig.debugJsonRule) {
                    JsonRule.dumpSpec("json-rule-opt", spec);
                }
            }
            jsonRule = spec.build();
        }
        catch (Exception e) {
            Apathy.LOG.error("Problem finalizing rule", (Throwable)e);
        }
    }

    public static void dumpSpec(String filename, RuleSpec spec) {
        try {
            Files.createDirectories(DUMP_DIR, new FileAttribute[0]);
            Path outPath = DUMP_DIR.resolve(filename + ".json");
            Apathy.LOG.info("Dumping rule to " + outPath);
            DataResult jsonResult = Specs.RULE_SPEC_CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)spec);
            JsonElement json = (JsonElement)jsonResult.getOrThrow(false, arg_0 -> ((Logger)Apathy.LOG).error(arg_0));
            Files.writeString(outPath, (CharSequence)GSON.toJson(json), new OpenOption[0]);
        }
        catch (Exception e) {
            Apathy.LOG.error("Problem dumping rule to " + filename, (Throwable)e);
        }
    }

    static {
        MOBS_JSON = Apathy.CONFIG_FOLDER.resolve("mobs.json");
        DUMP_DIR = Apathy.CONFIG_FOLDER.resolve("dumps");
        GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    }
}

