/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.apathy;

import agency.highlysuspect.apathy.Apathy;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.saveddata.SavedData;

public class PlayerSetManager
extends SavedData {
    private final ConcurrentHashMap<String, Entry> playerSets = new ConcurrentHashMap();

    public PlayerSetManager() {
    }

    public PlayerSetManager(CompoundTag tag) {
        this();
        CompoundTag allSets = tag.m_128469_("PlayerSets");
        for (String name : allSets.m_128431_()) {
            this.playerSets.put(name, Entry.fromTag(allSets.m_128469_(name)));
        }
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        CompoundTag allSets = new CompoundTag();
        for (Map.Entry<String, Entry> entry : this.playerSets.entrySet()) {
            allSets.m_128365_(entry.getKey(), (Tag)entry.getValue().toTag());
        }
        tag.m_128365_("PlayerSets", (Tag)allSets);
        return tag;
    }

    public static PlayerSetManager getFor(MinecraftServer server) {
        return (PlayerSetManager)server.m_129783_().m_8895_().m_164861_(PlayerSetManager::new, PlayerSetManager::new, "apathy-player-sets");
    }

    public static PlayerSetManager getFor(CommandContext<CommandSourceStack> cmdCtx) {
        return PlayerSetManager.getFor(((CommandSourceStack)cmdCtx.getSource()).m_81377_());
    }

    public boolean playerInSet(ServerPlayer player, String name) {
        Entry set = this.playerSets.get(name);
        if (set == null) {
            return false;
        }
        return set.contains(player);
    }

    public void syncWithConfig() {
        Optional<String> configSetName = Apathy.mobConfig.playerSetName;
        if (configSetName.isPresent()) {
            String name = configSetName.get();
            Entry set = this.playerSets.get(name);
            if (set == null) {
                set = Entry.newEmpty(Apathy.mobConfig.playerSetSelfSelect);
                this.playerSets.put(name, set);
                this.m_77762_();
            }
            if (set.selfSelect != Apathy.mobConfig.playerSetSelfSelect) {
                this.playerSets.put(name, set.withSelfSelect(Apathy.mobConfig.playerSetSelfSelect));
                this.m_77762_();
            }
        }
    }

    public JoinResult join(ServerPlayer player, String name, boolean op) {
        Entry set = this.playerSets.get(name);
        if (set == null) {
            return JoinResult.NO_SUCH_SET;
        }
        if (!op && !set.selfSelect()) {
            return JoinResult.NOT_SELF_SELECT;
        }
        if (set.contains(player)) {
            return JoinResult.ALREADY_IN_SET;
        }
        this.playerSets.put(name, set.withAddition(player));
        this.m_77762_();
        return JoinResult.SUCCESS;
    }

    public PartResult part(ServerPlayer player, String name, boolean op) {
        Entry set = this.playerSets.get(name);
        if (set == null) {
            return PartResult.NO_SUCH_SET;
        }
        if (!op && !set.selfSelect()) {
            return PartResult.NOT_SELF_SELECT;
        }
        if (!set.contains(player)) {
            return PartResult.ALREADY_NOT_IN_SET;
        }
        this.playerSets.put(name, set.withRemoval(player));
        this.m_77762_();
        return PartResult.SUCCESS;
    }

    public DeleteResult delete(String name) {
        Entry removed = this.playerSets.remove(name);
        if (removed == null) {
            return DeleteResult.NO_SUCH_SET;
        }
        this.m_77762_();
        return DeleteResult.SUCCESS;
    }

    public EditResult edit(String name, boolean newSelfSelect) {
        Entry set = this.playerSets.get(name);
        if (set == null) {
            return EditResult.NO_SUCH_SET;
        }
        if (set.selfSelect && newSelfSelect) {
            return EditResult.ALREADY_SELF_SELECT;
        }
        if (!set.selfSelect && !newSelfSelect) {
            return EditResult.ALREADY_NOT_SELF_SELECT;
        }
        this.playerSets.put(name, set.withSelfSelect(newSelfSelect));
        this.m_77762_();
        return EditResult.SUCCESS;
    }

    public CreateResult create(String name, boolean newSelfSelect) {
        if (this.playerSets.get(name) != null) {
            return CreateResult.ALREADY_EXISTS;
        }
        this.playerSets.put(name, Entry.newEmpty(newSelfSelect));
        this.m_77762_();
        return CreateResult.SUCCESS;
    }

    public boolean isEmpty() {
        return this.playerSets.isEmpty();
    }

    public Set<Map.Entry<String, Entry>> entrySet() {
        return this.playerSets.entrySet();
    }

    public static CompletableFuture<Suggestions> suggestSelfSelectPlayerSets(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        PlayerSetManager setManager = PlayerSetManager.getFor(context);
        return SharedSuggestionProvider.m_82970_((Iterable)setManager.playerSets.entrySet().stream().filter(entry -> ((Entry)entry.getValue()).selfSelect()).map(Map.Entry::getKey).collect(Collectors.toList()), (SuggestionsBuilder)builder);
    }

    public static CompletableFuture<Suggestions> suggestAllPlayerSets(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        PlayerSetManager setManager = PlayerSetManager.getFor(context);
        return SharedSuggestionProvider.m_82970_(new ArrayList(setManager.playerSets.keySet()), (SuggestionsBuilder)builder);
    }

    public Component printAllPlayerSets() {
        return ComponentUtils.m_178440_(this.playerSets.entrySet(), entry -> new TextComponent((String)entry.getKey() + (((Entry)entry.getValue()).selfSelect() ? " (self-select)" : "")));
    }

    public record Entry(Set<UUID> members, boolean selfSelect) {
        public static Entry newEmpty(boolean selfSelect) {
            return new Entry(new HashSet<UUID>(), selfSelect);
        }

        public boolean contains(ServerPlayer player) {
            return this.members.contains(player.m_142081_());
        }

        public Entry withAddition(ServerPlayer newPlayer) {
            HashSet<UUID> members2 = new HashSet<UUID>(this.members);
            members2.add(newPlayer.m_142081_());
            return new Entry(members2, this.selfSelect);
        }

        public Entry withRemoval(ServerPlayer removePlayer) {
            HashSet<UUID> members2 = new HashSet<UUID>(this.members);
            members2.remove(removePlayer.m_142081_());
            return new Entry(members2, this.selfSelect);
        }

        public Entry withSelfSelect(boolean newSelfSelect) {
            return new Entry(this.members, newSelfSelect);
        }

        public static Entry fromTag(CompoundTag tag) {
            HashSet<UUID> members = new HashSet<UUID>();
            ListTag memberList = tag.m_128437_("Members", 11);
            for (Tag value : memberList) {
                members.add(NbtUtils.m_129233_((Tag)value));
            }
            return new Entry(members, tag.m_128471_("SelfSelect"));
        }

        public CompoundTag toTag() {
            CompoundTag tag = new CompoundTag();
            ListTag memberList = new ListTag();
            for (UUID uuid : this.members) {
                memberList.add((Object)NbtUtils.m_129226_((UUID)uuid));
            }
            tag.m_128365_("Members", (Tag)memberList);
            tag.m_128379_("SelfSelect", this.selfSelect);
            return tag;
        }
    }

    public static enum JoinResult {
        SUCCESS,
        NO_SUCH_SET,
        ALREADY_IN_SET,
        NOT_SELF_SELECT;

    }

    public static enum PartResult {
        SUCCESS,
        NO_SUCH_SET,
        ALREADY_NOT_IN_SET,
        NOT_SELF_SELECT;

    }

    public static enum DeleteResult {
        SUCCESS,
        NO_SUCH_SET;

    }

    public static enum EditResult {
        SUCCESS,
        NO_SUCH_SET,
        ALREADY_SELF_SELECT,
        ALREADY_NOT_SELF_SELECT;

    }

    public static enum CreateResult {
        SUCCESS,
        ALREADY_EXISTS;

    }
}

