/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.apathy.config;

import agency.highlysuspect.apathy.config.annotation.AtLeast;
import agency.highlysuspect.apathy.config.annotation.Blankline;
import agency.highlysuspect.apathy.config.annotation.Comment;
import agency.highlysuspect.apathy.config.annotation.Example;
import agency.highlysuspect.apathy.config.annotation.NoDefault;
import agency.highlysuspect.apathy.config.annotation.Note;
import agency.highlysuspect.apathy.config.annotation.Section;
import agency.highlysuspect.apathy.config.types.FieldSerde;
import agency.highlysuspect.apathy.config.types.Types;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public abstract class Config {
    protected transient HashMap<String, String> unknownKeys;
    protected final transient Path path = null;

    protected Config() {
    }

    public static <T extends Config> T read(T inst, Path configFilePath) throws IOException {
        if (Files.exists(configFilePath, new LinkOption[0])) {
            inst.parse(configFilePath).upgrade().save(configFilePath).finish();
        } else {
            inst.save(configFilePath).finish();
        }
        return inst;
    }

    protected Config upgrade() {
        return this;
    }

    protected Config finish() {
        return this;
    }

    protected Config parse(Path configFilePath) throws IOException {
        List<String> lines = Files.readAllLines(configFilePath, StandardCharsets.UTF_8);
        for (int lineNo = 0; lineNo < lines.size(); ++lineNo) {
            try {
                String line = lines.get(lineNo).trim();
                if (line.isEmpty() || line.startsWith("#")) continue;
                int colonIdx = line.indexOf(58);
                if (colonIdx == -1) {
                    throw new ConfigParseException(lineNo, new RuntimeException("No key-value pair (missing : character)"));
                }
                String key = line.substring(0, colonIdx).trim();
                String value = line.substring(colonIdx + 1).trim();
                Field keyField = this.findConfigField(key);
                if (keyField == null) {
                    if (this.unknownKeys == null) {
                        this.unknownKeys = new HashMap();
                    }
                    this.unknownKeys.put(key, value);
                    continue;
                }
                FieldSerde parser = Types.find(keyField);
                keyField.set(this, parser.parse(keyField, value));
                continue;
            }
            catch (IllegalAccessException | RuntimeException e) {
                throw new ConfigParseException(lineNo, e);
            }
        }
        return this;
    }

    @Nullable
    private Field findConfigField(String name) {
        try {
            Field field = this.getClass().getDeclaredField(name);
            if ((field.getModifiers() & 0x98) != 0) {
                return null;
            }
            field.setAccessible(true);
            return field;
        }
        catch (ReflectiveOperationException e) {
            return null;
        }
    }

    protected Config save(Path configFilePath) throws IOException {
        Config defaultConfig;
        try {
            defaultConfig = (Config)this.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Can't instantiate the default copy of " + this.getClass().toGenericString());
        }
        ArrayList<Object> lines = new ArrayList<Object>();
        for (Field field : this.getClass().getDeclaredFields()) {
            Note note;
            Example example;
            AtLeast atLeast;
            Comment comment;
            Section section;
            if ((field.getModifiers() & 0x98) != 0) continue;
            if (field.getDeclaredAnnotation(Blankline.class) != null) {
                lines.add("");
            }
            if ((section = field.getDeclaredAnnotation(Section.class)) != null) {
                String s = section.value();
                String[] bar = StringUtils.repeat((char)'#', (int)(s.length() + 6));
                lines.add(bar);
                lines.add("## " + s + " ##");
                lines.add(bar);
                lines.add("");
            }
            if ((comment = field.getDeclaredAnnotation(Comment.class)) != null) {
                for (String commentLine : comment.value()) {
                    lines.add("# " + commentLine);
                }
            }
            if ((atLeast = field.getDeclaredAnnotation(AtLeast.class)) != null) {
                if (atLeast.minInt() != Integer.MIN_VALUE) {
                    lines.add("# Must be at least " + atLeast.minInt() + ".");
                } else if (atLeast.minLong() != Long.MIN_VALUE) {
                    lines.add("# Must be at least " + atLeast.minLong() + ".");
                }
            }
            if ((example = field.getDeclaredAnnotation(Example.class)) != null) {
                for (String commentLine : example.value()) {
                    lines.add("# Example: " + commentLine);
                }
            }
            if ((note = field.getDeclaredAnnotation(Note.class)) != null) {
                boolean first = true;
                for (String noteLine : note.value()) {
                    lines.add((first ? "# Note: " : "#       ") + noteLine);
                    first = false;
                }
            }
            FieldSerde ser = Types.find(field);
            try {
                if (field.getDeclaredAnnotation(NoDefault.class) == null) {
                    String defaultValue = ser.writeErased(field, field.get(defaultConfig));
                    lines.add("# Default: " + (defaultValue.isEmpty() ? "<empty>" : defaultValue));
                }
                lines.add(field.getName() + ": " + ser.writeErased(field, field.get(this)));
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException("Uh oh", e);
            }
            lines.add("");
        }
        Files.write(configFilePath, lines, new OpenOption[0]);
        return this;
    }

    protected class ConfigParseException
    extends RuntimeException {
        public ConfigParseException(int lineNo, Throwable cause) {
            super("Problem in config file " + Config.this.path + " on line " + lineNo, cause);
            this.setStackTrace(new StackTraceElement[0]);
        }
    }
}

