/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.apathy.config;

import agency.highlysuspect.apathy.Apathy;
import agency.highlysuspect.apathy.JsonRule;
import agency.highlysuspect.apathy.TriState;
import agency.highlysuspect.apathy.config.Config;
import agency.highlysuspect.apathy.config.annotation.AtLeast;
import agency.highlysuspect.apathy.config.annotation.Comment;
import agency.highlysuspect.apathy.config.annotation.Example;
import agency.highlysuspect.apathy.config.annotation.NoDefault;
import agency.highlysuspect.apathy.config.annotation.Note;
import agency.highlysuspect.apathy.config.annotation.Section;
import agency.highlysuspect.apathy.config.annotation.Use;
import agency.highlysuspect.apathy.rule.Rule;
import agency.highlysuspect.apathy.rule.spec.AlwaysRuleSpec;
import agency.highlysuspect.apathy.rule.spec.ChainRuleSpec;
import agency.highlysuspect.apathy.rule.spec.JsonRuleSpec;
import agency.highlysuspect.apathy.rule.spec.PredicatedRuleSpec;
import agency.highlysuspect.apathy.rule.spec.RuleSpec;
import agency.highlysuspect.apathy.rule.spec.predicate.AttackerIsBossPredicateSpec;
import agency.highlysuspect.apathy.rule.spec.predicate.AttackerIsPredicateSpec;
import agency.highlysuspect.apathy.rule.spec.predicate.AttackerTaggedWithPredicateSpec;
import agency.highlysuspect.apathy.rule.spec.predicate.DefenderInPlayerSetPredicateSpec;
import agency.highlysuspect.apathy.rule.spec.predicate.DifficultyIsPredicateSpec;
import agency.highlysuspect.apathy.rule.spec.predicate.RevengeTimerPredicateSpec;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.Tag;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;

public class MobConfig
extends Config {
    protected static final int CURRENT_CONFIG_VERSION = 0;
    protected transient RuleSpec ruleSpec;
    protected transient Rule rule;
    @NoDefault
    protected int configVersion = 0;
    @Section(value="Nuclear Option")
    @Comment(value={"If set to 'true', no mob will ever attack anyone.", "Use this option if you don't want to deal with the rest of the config file."})
    public boolean nuclearOption = false;
    @Section(value="Built In Rule Order")
    @Comment(value={"Which order should the rules in this config file be evaluated in?", "Comma-separated list built out of any or all of the following keywords, in any order:", "json, difficulty, boss, mobSet, tagSet, playerSet, revenge"})
    @Note(value={"If a rule is not listed in the rule order, it will not be checked."})
    @Example(value={"difficulty, revenge, playerSet"})
    @Use(value="stringList")
    public List<String> ruleOrder = ImmutableList.of((Object)"json", (Object)"difficulty", (Object)"boss", (Object)"mobSet", (Object)"tagSet", (Object)"playerSet", (Object)"revenge");
    @Section(value="Difficulty Rule")
    @Comment(value={"Comma-separated list of difficulties."})
    @Example(value={"easy, normal"})
    @Use(value="difficultySet")
    public Set<Difficulty> difficultySet = Collections.emptySet();
    @Comment(value={"What happens when the current world difficulty appears in difficultySet?", "May be one of:", "allow - Every mob is always allowed to attack everyone.", "deny  - No mob is ever allowed to attack anyone.", "pass  - Defer to the next rule."})
    @Use(value="triStateAllowDenyPass")
    public TriState difficultySetIncluded = TriState.DEFAULT;
    @Comment(value={"What happens when the current world difficulty does *not* appear in difficultySet?", "May be one of:", "allow - Every mob is always allowed to attack everyone.", "deny  - No mob is ever allowed to attack anyone.", "pass  - Defer to the next rule."})
    @Use(value="triStateAllowDenyPass")
    public TriState difficultySetExcluded = TriState.DEFAULT;
    @Section(value="Boss Rule")
    @Comment(value={"What happens when the attacker is a boss?", "'Bossness' is defined by inclusion in the 'apathy:bosses' tag.", "May be one of:", "allow - Every boss is allowed to attack everyone.", "deny  - No boss is allowed to attack anyone.", "pass  - Defer to the next rule."})
    @Note(value={"If the current attacker is *not* a boss, always passes to the next rule."})
    @Use(value="triStateAllowDenyPass")
    public TriState boss = TriState.TRUE;
    @Section(value="Mob Set Rule")
    @Comment(value={"A comma-separated set of mob IDs."})
    @Example(value={"minecraft:creeper, minecraft:spider"})
    @Use(value="entityTypeSet")
    public Set<EntityType<?>> mobSet = Collections.emptySet();
    @Comment(value={"What happens when the attacker's entity ID appears in mobSet?", "May be one of:", "allow - The mob will be allowed to attack the player.", "deny  - The mob will not be allowed to attack the player.", "pass  - Defer to the next rule."})
    @Use(value="triStateAllowDenyPass")
    public TriState mobSetIncluded = TriState.DEFAULT;
    @Comment(value={"What happens when the attacker's entity ID does *not* appear in mobSet?", "May be one of:", "allow - The mob will be allowed to attack the player.", "deny  - The mob will not be allowed to attack the player.", "pass  - Defer to the next rule."})
    @Use(value="triStateAllowDenyPass")
    public TriState mobSetExcluded = TriState.DEFAULT;
    @Section(value="Tag Set Rule")
    @Comment(value={"A comma-separated set of entity type tags."})
    @Example(value={"minecraft:raiders, some_datapack:some_tag"})
    @Use(value="entityTypeTagSet")
    public Set<Tag<EntityType<?>>> tagSet = Collections.emptySet();
    @Comment(value={"What happens when the attacker is tagged with one of the tags in mobTagSet?", "May be one of:", "allow - The mob will be allowed to attack the player.", "deny  - The mob will not be allowed to attack the player.", "pass  - Defer to the next rule."})
    @Use(value="triStateAllowDenyPass")
    public TriState tagSetIncluded = TriState.DEFAULT;
    @Comment(value={"What happens when the attacker is *not* tagged with one of the tags in mobTagSet?", "May be one of:", "allow - The mob will be allowed to attack the player.", "deny  - The mob will not be allowed to attack the player.", "pass  - Defer to the next rule."})
    @Use(value="triStateAllowDenyPass")
    public TriState tagSetExcluded = TriState.DEFAULT;
    @Section(value="Player Set Rule")
    @Comment(value={"The name of a set of players.", "If this option is not provided, a player set is not created, and this whole rule always passes."})
    @Use(value="optionalString")
    public Optional<String> playerSetName = Optional.of("no-mobs");
    @Comment(value={"If 'true', players can add themselves to the set, using '/apathy set join <playerListName>'.", "If 'false', only an operator can add them to the set, using '/apathy set-admin join <selector> <playerListName>'."})
    public boolean playerSetSelfSelect = true;
    @Comment(value={"What happens when a mob tries to attack someone who appears in the playerSet?", "May be one of:", "allow - The mob is allowed to attack the player.", "deny  - The mob is not allowed to attack the player.", "pass  - Defer to the next rule."})
    @Use(value="triStateAllowDenyPass")
    public TriState playerSetIncluded = TriState.FALSE;
    @Comment(value={"What happens when a mob tries to attack someone who does *not* appear in the playerSet?", "May be one of:", "allow - The mob is allowed to attack the player.", "deny  - The mob is not allowed to attack the player.", "pass  - Defer to the next rule."})
    @Use(value="triStateAllowDenyPass")
    public TriState playerSetExcluded = TriState.DEFAULT;
    @Section(value="Revenge Rule")
    @Comment(value={"For how many ticks is a mob allowed to retaliate after being attacked?", "Set to -1 to disable this 'revenge' mechanic.", "When the timer expires, defers to the next rule."})
    @Note(value={"The exact duration of the attack may be up to (<revengeTimer> + <recheckInterval>) ticks.", "Btw, the original mod had an option for 'eternal revenge', with an uncapped timer.", "I didn't port that, but the maximum value of the timer is 9223372036854775807 ticks.", "Make of that information what you will ;)"})
    @AtLeast(minLong=-1L)
    public long revengeTimer = -1L;
    @Section(value="Last Resort Rule")
    @Comment(value={"If absolutely none of the previous rules applied, what happens?", "May be one of:", "allow - By default, mobs are allowed to attack players.", "deny  - By default, mobs are not allowed to attack players.", "May *not* be set to 'pass'."})
    @Use(value="boolAllowDeny")
    public boolean fallthrough = true;

    public boolean allowedToTargetPlayer(Mob attacker, ServerPlayer player) {
        if (attacker.f_19853_.f_46443_) {
            throw new IllegalStateException("Do not call on the client, please");
        }
        TriState result = (TriState)((Object)this.rule.apply(attacker, player));
        if (result != TriState.DEFAULT) {
            return result.get();
        }
        return this.fallthrough;
    }

    @Override
    public Config upgrade() {
        super.upgrade();
        if (this.unknownKeys != null) {
            this.unknownKeys.forEach((key, value) -> Apathy.LOG.warn("Unknown config field: " + key));
            this.unknownKeys = null;
        }
        this.configVersion = 0;
        return this;
    }

    @Override
    public Config finish() {
        super.finish();
        if (this.nuclearOption) {
            Apathy.LOG.info("Nuclear option enabled - Ignoring ALL rules in the config file");
            this.ruleSpec = AlwaysRuleSpec.ALWAYS_DENY;
        } else {
            ArrayList<RuleSpec> ruleSpecList = new ArrayList<RuleSpec>();
            block18: for (String ruleName : this.ruleOrder) {
                switch (ruleName.trim().toLowerCase(Locale.ROOT)) {
                    case "json": {
                        ruleSpecList.add(new JsonRuleSpec());
                        continue block18;
                    }
                    case "difficulty": {
                        ruleSpecList.add(new PredicatedRuleSpec(this.difficultySetIncluded, this.difficultySetExcluded, new DifficultyIsPredicateSpec(this.difficultySet)));
                        continue block18;
                    }
                    case "boss": {
                        ruleSpecList.add(new PredicatedRuleSpec(this.boss, TriState.DEFAULT, new AttackerIsBossPredicateSpec()));
                        continue block18;
                    }
                    case "mobset": {
                        ruleSpecList.add(new PredicatedRuleSpec(this.mobSetIncluded, this.mobSetExcluded, new AttackerIsPredicateSpec(this.mobSet)));
                        continue block18;
                    }
                    case "tagset": {
                        ruleSpecList.add(new PredicatedRuleSpec(this.tagSetIncluded, this.tagSetExcluded, new AttackerTaggedWithPredicateSpec(this.tagSet)));
                        continue block18;
                    }
                    case "playerset": {
                        this.playerSetName.ifPresent(s -> ruleSpecList.add(new PredicatedRuleSpec(this.playerSetIncluded, this.playerSetExcluded, new DefenderInPlayerSetPredicateSpec(Collections.singleton(s)))));
                        continue block18;
                    }
                    case "revenge": {
                        ruleSpecList.add(PredicatedRuleSpec.allowIf(new RevengeTimerPredicateSpec(this.revengeTimer)));
                        continue block18;
                    }
                }
                Apathy.LOG.warn("Unknown rule " + ruleName + " listed in the ruleOrder config option.");
            }
            this.ruleSpec = new ChainRuleSpec(ruleSpecList);
        }
        if (Apathy.generalConfig.debugBuiltinRule) {
            JsonRule.dumpSpec("builtin-rule", this.ruleSpec);
        }
        if (Apathy.generalConfig.runRuleOptimizer) {
            this.ruleSpec = this.ruleSpec.optimize();
            if (Apathy.generalConfig.debugBuiltinRule) {
                JsonRule.dumpSpec("builtin-rule-opt", this.ruleSpec);
            }
        }
        this.rule = this.ruleSpec.build();
        return this;
    }
}

