/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.apathy.config.types;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public interface FieldSerde<T> {
    public String write(Field var1, T var2);

    public T parse(Field var1, String var2);

    default public String writeErased(Field targetField, Object value) {
        return this.write(targetField, value);
    }

    default public <U> FieldSerde<U> dimap(final Function<T, U> into, final Function<U, T> from) {
        final FieldSerde me = this;
        return new FieldSerde<U>(){

            @Override
            public String write(Field targetField, U value) {
                return me.write(targetField, from.apply(value));
            }

            @Override
            public U parse(Field sourceField, String value) {
                return into.apply(me.parse(sourceField, value));
            }
        };
    }

    default public FieldSerde<Set<T>> commaSeparatedSet(final Comparator<T> sorter) {
        final FieldSerde me = this;
        return new FieldSerde<Set<T>>(){

            @Override
            public String write(Field targetField, Set<T> value) {
                if (value == null) {
                    value = Collections.emptySet();
                }
                ArrayList hahaYes = new ArrayList(value);
                hahaYes.sort(sorter);
                StringBuilder bob = new StringBuilder();
                for (int i = 0; i < hahaYes.size(); ++i) {
                    bob.append(me.write(targetField, hahaYes.get(i)));
                    if (i == hahaYes.size() - 1) continue;
                    bob.append(", ");
                }
                return bob.toString();
            }

            @Override
            public Set<T> parse(Field sourceField, String value) {
                return Arrays.stream(value.split(",")).map(String::trim).filter(s -> !s.isEmpty()).map(s -> me.parse(sourceField, (String)s)).collect(Collectors.toSet());
            }
        };
    }

    default public FieldSerde<List<T>> commaSeparatedList() {
        final FieldSerde me = this;
        return new FieldSerde<List<T>>(){

            @Override
            public String write(Field targetField, List<T> value) {
                StringBuilder bob = new StringBuilder();
                for (int i = 0; i < value.size(); ++i) {
                    bob.append(me.write(targetField, value.get(i)));
                    if (i == value.size() - 1) continue;
                    bob.append(", ");
                }
                return bob.toString();
            }

            @Override
            public List<T> parse(Field sourceField, String value) {
                return Arrays.stream(value.split(",")).map(String::trim).filter(s -> !s.isEmpty()).map(s -> me.parse(sourceField, (String)s)).collect(Collectors.toList());
            }
        };
    }

    default public FieldSerde<Optional<T>> optional() {
        final FieldSerde me = this;
        return new FieldSerde<Optional<T>>(){

            @Override
            public String write(Field targetField, Optional<T> value) {
                if (value.isPresent()) {
                    return me.write(targetField, value.get());
                }
                return "";
            }

            @Override
            public Optional<T> parse(Field sourceField, String value) {
                if (value.isEmpty()) {
                    return Optional.empty();
                }
                return Optional.of(me.parse(sourceField, value));
            }
        };
    }

    public static interface ToString<T>
    extends FieldSerde<T> {
        @Override
        default public String write(Field targetField, T value) {
            return value.toString();
        }
    }
}

