/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.apathy.config.types;

import agency.highlysuspect.apathy.Apathy;
import agency.highlysuspect.apathy.TriState;
import agency.highlysuspect.apathy.config.types.FieldSerde;
import java.lang.reflect.Field;

public class TriStateField {

    public static class AllowDenyPass
    implements FieldSerde<TriState> {
        @Override
        public TriState parse(Field sourceField, String value) {
            switch (value) {
                case "allow": {
                    return TriState.TRUE;
                }
                case "deny": {
                    return TriState.FALSE;
                }
                case "pass": {
                    return TriState.DEFAULT;
                }
            }
            Apathy.LOG.warn("Value " + value + " on field " + sourceField.getName() + " is not one of allow/deny/pass. Defaulting to 'pass'.");
            return TriState.DEFAULT;
        }

        @Override
        public String write(Field targetField, TriState value) {
            return switch (value) {
                default -> throw new IncompatibleClassChangeError();
                case TriState.TRUE -> "allow";
                case TriState.FALSE -> "deny";
                case TriState.DEFAULT -> "pass";
            };
        }
    }
}

