/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.apathy.config.types;

import agency.highlysuspect.apathy.config.annotation.Use;
import agency.highlysuspect.apathy.config.types.BooleanSerde;
import agency.highlysuspect.apathy.config.types.DifficultySerde;
import agency.highlysuspect.apathy.config.types.FieldSerde;
import agency.highlysuspect.apathy.config.types.IntSerde;
import agency.highlysuspect.apathy.config.types.LongSerde;
import agency.highlysuspect.apathy.config.types.StringSerde;
import agency.highlysuspect.apathy.config.types.TriStateField;
import agency.highlysuspect.apathy.platform.PlatformSupport;
import java.lang.reflect.Field;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.Tag;
import net.minecraft.world.Difficulty;

public class Types {
    static final Map<Class<?>, FieldSerde<?>> builtinParsers = new HashMap();
    static final Map<String, FieldSerde<?>> customParsers = new HashMap();

    public static <T> FieldSerde<T> find(Field field) {
        Use pw = field.getAnnotation(Use.class);
        if (pw != null) {
            return customParsers.get(pw.value());
        }
        if (builtinParsers.containsKey(field.getType())) {
            return builtinParsers.get(field.getType());
        }
        throw new RuntimeException("No parser for field " + field.toGenericString());
    }

    static {
        FieldSerde<ResourceLocation> ident = new StringSerde().dimap(ResourceLocation::new, ResourceLocation::toString);
        builtinParsers.put(String.class, new StringSerde());
        builtinParsers.put(ResourceLocation.class, ident);
        builtinParsers.put(Integer.TYPE, new IntSerde());
        builtinParsers.put(Boolean.TYPE, new BooleanSerde());
        builtinParsers.put(Long.TYPE, new LongSerde());
        customParsers.put("difficultySet", new DifficultySerde().commaSeparatedSet(Comparator.comparingInt(Difficulty::m_19028_)));
        customParsers.put("entityTypeSet", ident.dimap(arg_0 -> ((DefaultedRegistry)Registry.f_122826_).m_7745_(arg_0), arg_0 -> ((DefaultedRegistry)Registry.f_122826_).m_7981_(arg_0)).commaSeparatedSet(Comparator.comparing(arg_0 -> ((DefaultedRegistry)Registry.f_122826_).m_7981_(arg_0))));
        customParsers.put("triStateAllowDenyPass", new TriStateField.AllowDenyPass());
        customParsers.put("optionalString", new StringSerde().optional());
        customParsers.put("boolAllowDeny", new StringSerde().dimap(s -> s.equals("allow"), b -> b != false ? "allow" : "deny"));
        customParsers.put("stringList", new StringSerde().commaSeparatedList());
        customParsers.put("entityTypeTagSet", ident.dimap(PlatformSupport.instance::entityTypeTag, Tag.Named::m_6979_).commaSeparatedSet(Comparator.comparing(Tag.Named::m_6979_)));
    }
}

