/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.apathy.mixin;

import agency.highlysuspect.apathy.Apathy;
import agency.highlysuspect.apathy.MobExt;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Mob.class})
public class MobMixin
implements MobExt {
    @Shadow
    private LivingEntity f_21362_;
    @Unique
    private static final long NOT_PROVOKED = Long.MIN_VALUE;
    @Unique
    private static final String PROVOCATION_KEY = "apathy-provocationTime";
    @Unique
    long provocationTime = Long.MIN_VALUE;

    @Inject(method={"setTarget"}, at={@At(value="HEAD")}, cancellable=true)
    public void whenSettingTarget(@Nullable LivingEntity newTarget, CallbackInfo ci) {
        Mob thi$ = (Mob)this;
        if (thi$.f_19853_.f_46443_) {
            return;
        }
        if (newTarget instanceof ServerPlayer && !Apathy.mobConfig.allowedToTargetPlayer(thi$, (ServerPlayer)newTarget)) {
            ci.cancel();
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    public void whenTicking(CallbackInfo ci) {
        Mob thi$ = (Mob)this;
        if (thi$.f_19853_.f_46443_) {
            return;
        }
        if ((thi$.f_19853_.m_46467_() + (long)thi$.m_142049_()) % (long)Apathy.generalConfig.recheckInterval == 0L && this.f_21362_ instanceof ServerPlayer && !Apathy.mobConfig.allowedToTargetPlayer(thi$, (ServerPlayer)this.f_21362_)) {
            this.f_21362_ = null;
        }
    }

    @Override
    public void apathy$provokeNow() {
        this.provocationTime = ((Mob)this).f_19853_.m_46467_();
    }

    @Override
    public long apathy$timeSinceProvocation() {
        return ((Mob)this).f_19853_.m_46467_() - this.provocationTime;
    }

    @Override
    public boolean apathy$wasProvoked() {
        return this.provocationTime != Long.MIN_VALUE;
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="RETURN")})
    public void whenSaving(CompoundTag tag, CallbackInfo ci) {
        if (this.apathy$wasProvoked()) {
            tag.m_128356_(PROVOCATION_KEY, this.provocationTime);
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="RETURN")})
    public void whenLoading(CompoundTag tag, CallbackInfo ci) {
        this.provocationTime = tag.m_128441_(PROVOCATION_KEY) ? tag.m_128454_(PROVOCATION_KEY) : Long.MIN_VALUE;
    }
}

