/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.apathy.mixin.dragon;

import agency.highlysuspect.apathy.Apathy;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.Mth;
import net.minecraft.util.Unit;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.dimension.end.DragonRespawnAnimation;
import net.minecraft.world.level.dimension.end.EndDragonFight;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.EndPodiumFeature;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EndDragonFight.class})
public abstract class EndDragonFightMixin {
    @Shadow
    @Final
    private static Predicate<Entity> f_64059_;
    @Shadow
    @Final
    private ServerBossEvent f_64060_;
    @Shadow
    @Final
    private ServerLevel f_64061_;
    @Shadow
    @Final
    private List<Integer> f_64062_;
    @Shadow
    private boolean f_64068_;
    @Shadow
    private UUID f_64070_;
    @Shadow
    private boolean f_64071_;
    @Shadow
    private BlockPos f_64072_;
    @Shadow
    private DragonRespawnAnimation f_64073_;
    @Shadow
    private List<EndCrystal> f_64075_;
    @Unique
    private boolean createdApathyPortal;
    @Unique
    private int gatewayTimer = -100;
    @Unique
    private static final int NOT_RUNNING = -100;
    @Unique
    private static final String APATHY_CREATEDPORTAL = "apathy-created-exit-portal";
    @Unique
    private static final String APATHY_GATEWAYTIMER = "apathy-gateway-timer";

    @Shadow
    protected abstract boolean m_64106_();

    @Shadow
    protected abstract void m_64109_();

    @Shadow
    protected abstract void m_64093_(boolean var1);

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    void onInit(ServerLevel world, long l, CompoundTag tag, CallbackInfo ci) {
        this.createdApathyPortal = tag.m_128471_(APATHY_CREATEDPORTAL);
        this.gatewayTimer = tag.m_128441_(APATHY_GATEWAYTIMER) ? tag.m_128451_(APATHY_GATEWAYTIMER) : -100;
        if (Apathy.bossConfig.noDragon) {
            this.f_64068_ = true;
            this.f_64070_ = null;
            this.f_64071_ = false;
            this.f_64073_ = null;
        }
    }

    @Inject(method={"saveData"}, at={@At(value="RETURN")})
    void whenTagging(CallbackInfoReturnable<CompoundTag> cir) {
        CompoundTag tag = (CompoundTag)cir.getReturnValue();
        tag.m_128379_(APATHY_CREATEDPORTAL, this.createdApathyPortal);
        tag.m_128405_(APATHY_GATEWAYTIMER, this.gatewayTimer);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")}, cancellable=true)
    void dontTick(CallbackInfo ci) {
        if (Apathy.bossConfig.noDragon) {
            ci.cancel();
            this.f_64060_.m_7706_();
            this.f_64060_.m_8321_(false);
            for (EnderDragon dragon : this.f_64061_.m_8857_()) {
                dragon.m_146870_();
            }
            List players = this.f_64061_.m_8795_(f_64059_);
            if (players.isEmpty()) {
                this.f_64061_.m_7726_().m_8438_(TicketType.f_9443_, new ChunkPos(0, 0), 9, (Object)Unit.INSTANCE);
            } else {
                this.f_64061_.m_7726_().m_8387_(TicketType.f_9443_, new ChunkPos(0, 0), 9, (Object)Unit.INSTANCE);
                EnderDragon dummy = (EnderDragon)EntityType.f_20565_.m_20615_((Level)this.f_64061_);
                for (ServerPlayer player : players) {
                    CriteriaTriggers.f_10568_.m_48104_(player, (Entity)dummy, DamageSource.f_19321_);
                }
            }
            boolean chunksReady = this.m_64106_();
            if (chunksReady) {
                this.createApathyPortal();
                this.gatewayTimerTick();
            }
        }
    }

    @Inject(method={"setRespawnStage"}, at={@At(value="HEAD")}, cancellable=true)
    void dontSetSpawnState(DragonRespawnAnimation enderDragonSpawnState, CallbackInfo ci) {
        if (Apathy.bossConfig.noDragon) {
            this.f_64073_ = null;
            ci.cancel();
        }
    }

    @Inject(method={"createNewDragon"}, at={@At(value="HEAD")}, cancellable=true)
    void dontCreateDragon(CallbackInfoReturnable<EnderDragon> cir) {
        if (Apathy.bossConfig.noDragon) {
            cir.setReturnValue(null);
        }
    }

    @Inject(method={"respawnDragon(Ljava/util/List;)V"}, at={@At(value="HEAD")}, cancellable=true)
    void dontRespawnDragon(List<EndCrystal> crystals, CallbackInfo ci) {
        if (Apathy.bossConfig.noDragon) {
            ci.cancel();
            this.tryEnderCrystalGateway(crystals);
        }
    }

    @Unique
    private void createApathyPortal() {
        if (!this.createdApathyPortal) {
            this.m_64093_(true);
            this.f_64061_.m_46597_(this.f_64061_.m_5452_(Heightmap.Types.MOTION_BLOCKING, EndPodiumFeature.f_65714_), Blocks.f_50260_.m_49966_());
            this.createdApathyPortal = true;
        }
    }

    @Unique
    private void gatewayTimerTick() {
        if (this.gatewayTimer != -100) {
            if (this.gatewayTimer > 0) {
                --this.gatewayTimer;
            } else {
                this.doGatewaySpawn();
                this.gatewayTimer = -100;
            }
        }
    }

    @Unique
    private void doGatewaySpawn() {
        this.m_64109_();
        BlockPos exitPos = this.f_64072_;
        BlockPos oneAboveThat = exitPos.m_7494_();
        for (Direction d : Direction.Plane.HORIZONTAL) {
            for (EndCrystal crystal : this.f_64061_.m_45976_(EndCrystal.class, new AABB(oneAboveThat.m_5484_(d, 2)))) {
                crystal.m_31052_(null);
                this.f_64061_.m_46511_((Entity)crystal, crystal.m_20185_(), crystal.m_20186_(), crystal.m_20189_(), 6.0f, Explosion.BlockInteraction.NONE);
                crystal.m_146870_();
            }
        }
        EnderDragon dummy = (EnderDragon)EntityType.f_20565_.m_20615_((Level)this.f_64061_);
        for (ServerPlayer player : this.f_64061_.m_8795_(f_64059_)) {
            CriteriaTriggers.f_10580_.m_68256_(player, (Entity)dummy);
        }
    }

    @Unique
    private void tryEnderCrystalGateway(List<EndCrystal> crystalsAroundEndPortal) {
        BlockPos pos;
        if (this.gatewayTimer == -100 && (pos = this.gatewayDryRun()) != null) {
            BlockPos downABit = pos.m_6625_(2);
            for (EndCrystal crystal : crystalsAroundEndPortal) {
                crystal.m_31052_(downABit);
            }
            this.f_64075_ = crystalsAroundEndPortal;
            this.gatewayTimer = 100;
        }
    }

    @Unique
    @Nullable
    private BlockPos gatewayDryRun() {
        if (this.f_64062_.isEmpty()) {
            return null;
        }
        int i = this.f_64062_.get(this.f_64062_.size() - 1);
        int j = Mth.m_14107_((double)(96.0 * Math.cos(2.0 * (-Math.PI + 0.15707963267948966 * (double)i))));
        int k = Mth.m_14107_((double)(96.0 * Math.sin(2.0 * (-Math.PI + 0.15707963267948966 * (double)i))));
        return new BlockPos(j, 75, k);
    }
}

