/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.apathy.mixin.dragon;

import agency.highlysuspect.apathy.Apathy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EnderDragon.class})
public class EnderDragonMixin {
    @ModifyVariable(method={"knockBack"}, at=@At(value="HEAD"), argsOnly=true)
    private List<Entity> filterKnockBack(List<Entity> entities) {
        if (!Apathy.bossConfig.dragonKnockback) {
            return Collections.emptyList();
        }
        EnderDragon dergon = (EnderDragon)this;
        ArrayList<Entity> copy = new ArrayList<Entity>(entities);
        copy.removeIf(e -> {
            ServerPlayer player;
            return e instanceof ServerPlayer && !Apathy.mobConfig.allowedToTargetPlayer((Mob)dergon, player = (ServerPlayer)e);
        });
        return copy;
    }

    @ModifyVariable(method={"hurt(Ljava/util/List;)V"}, at=@At(value="HEAD"), argsOnly=true)
    private List<Entity> filterHurt(List<Entity> entities) {
        if (!Apathy.bossConfig.dragonDamage) {
            return Collections.emptyList();
        }
        EnderDragon dergon = (EnderDragon)this;
        ArrayList<Entity> copy = new ArrayList<Entity>(entities);
        copy.removeIf(e -> {
            ServerPlayer player;
            return e instanceof ServerPlayer && !Apathy.mobConfig.allowedToTargetPlayer((Mob)dergon, player = (ServerPlayer)e);
        });
        return copy;
    }

    @Inject(method={"canAttack"}, at={@At(value="HEAD")}, cancellable=true)
    private void copypasteFromLivingEntityMixin(LivingEntity target, CallbackInfoReturnable<Boolean> cir) {
        LivingEntity livingEntity = (LivingEntity)this;
        if (livingEntity instanceof Mob) {
            ServerPlayer player;
            Mob mob = (Mob)livingEntity;
            if (target instanceof ServerPlayer && !Apathy.mobConfig.allowedToTargetPlayer(mob, player = (ServerPlayer)target)) {
                cir.setReturnValue((Object)false);
            }
        }
    }
}

