/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.apathy.platform;

import agency.highlysuspect.apathy.Apathy;
import java.nio.file.Path;
import java.util.List;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.Tag;
import net.minecraft.world.entity.EntityType;

public abstract class PlatformSupport {
    public static final PlatformSupport instance;

    public void initialize() {
        this.installConfigFileReloader();
        this.installAttackCallback();
        this.installCommandRegistrationCallback();
        this.installPlayerSetManagerTicker();
    }

    public abstract void installConfigFileReloader();

    public abstract void installAttackCallback();

    public abstract void installCommandRegistrationCallback();

    public abstract void installPlayerSetManagerTicker();

    public abstract Path getConfigPath();

    public abstract Tag.Named<EntityType<?>> entityTypeTag(ResourceLocation var1);

    static {
        List<ServiceLoader.Provider<PlatformSupport>> providers = ServiceLoader.load(PlatformSupport.class).stream().toList();
        if (providers.size() != 1) {
            throw new IllegalStateException("There should be one PlatformSupport on the classpath, but I found these: " + providers.stream().map(p -> p.type().getName()).collect(Collectors.joining(",")));
        }
        ServiceLoader.Provider<PlatformSupport> provider = providers.get(0);
        Apathy.LOG.info("Found PlatformSupport: " + provider.type().getName());
        instance = provider.get();
    }
}

