/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.apathy.rule;

import agency.highlysuspect.apathy.TriState;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.Encoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.world.Difficulty;

public class CodecUtil {
    public static final Codec<Difficulty> DIFFICULTY = CodecUtil.enumCodec("difficulty", Difficulty.class);
    public static final Codec<TriState> TRISTATE_ALLOW_DENY_PASS = CodecUtil.renamedEnumCodec("tristate", TriState.class, "deny", "pass", "allow");

    public static <E extends Enum<E>> Codec<E> enumCodec(String errorName, Class<E> classs) {
        Enum[] values = (Enum[])classs.getEnumConstants();
        return CodecUtil.renamedEnumCodec(errorName, classs, (String[])Arrays.stream(values).map(e -> e.name().toLowerCase(Locale.ROOT)).toArray(String[]::new));
    }

    public static <E extends Enum<E>> Codec<E> renamedEnumCodec(String errorName, Class<E> classs, String ... names) {
        Enum[] values = (Enum[])classs.getEnumConstants();
        if (names.length != values.length) {
            throw new IllegalArgumentException("Enum has " + values.length + " values but only " + names.length + " names supplied to renamedEnumCodec");
        }
        String errorA = "Unknown " + errorName + " \"";
        String errorB = "\", must be one of " + Arrays.stream(names).map(n -> "\"" + n + "\"").collect(Collectors.joining(", "));
        return Codec.of((Encoder)Codec.STRING.comap(e -> names[e.ordinal()]), (Decoder)Codec.STRING.flatMap(s -> {
            for (int i = 0; i < values.length; ++i) {
                if (!s.equals(names[i])) continue;
                return DataResult.success((Object)values[i]);
            }
            return DataResult.error((String)(errorA + s + errorB));
        }), (String)("[renamedEnum " + errorName + "]"));
    }

    public static <T> Codec<Set<T>> setOf(Codec<T> codec) {
        return codec.listOf().xmap(HashSet::new, ArrayList::new);
    }
}

