/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.apathy.rule.spec;

import agency.highlysuspect.apathy.TriState;
import agency.highlysuspect.apathy.rule.Rule;
import agency.highlysuspect.apathy.rule.spec.AlwaysRuleSpec;
import agency.highlysuspect.apathy.rule.spec.RuleSpec;
import agency.highlysuspect.apathy.rule.spec.Specs;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public record ChainRuleSpec(List<RuleSpec> rules) implements RuleSpec
{
    public static final Codec<ChainRuleSpec> CODEC = RecordCodecBuilder.create(i -> i.group((App)Specs.RULE_SPEC_CODEC.listOf().fieldOf("rules").forGetter(x -> x.rules)).apply((Applicative)i, ChainRuleSpec::new));

    @Override
    public RuleSpec optimize() {
        List optimizedRules = this.rules.stream().map(RuleSpec::optimize).collect(Collectors.toList());
        if (optimizedRules.size() == 0) {
            return AlwaysRuleSpec.ALWAYS_PASS;
        }
        if (optimizedRules.size() == 1) {
            return (RuleSpec)optimizedRules.get(0);
        }
        if (optimizedRules.get(0) == AlwaysRuleSpec.ALWAYS_ALLOW) {
            return AlwaysRuleSpec.ALWAYS_ALLOW;
        }
        if (optimizedRules.get(0) == AlwaysRuleSpec.ALWAYS_DENY) {
            return AlwaysRuleSpec.ALWAYS_DENY;
        }
        ArrayList<RuleSpec> filteredRules = new ArrayList<RuleSpec>();
        for (RuleSpec spec : optimizedRules) {
            if (spec == AlwaysRuleSpec.ALWAYS_PASS) continue;
            filteredRules.add(spec);
            if (spec != AlwaysRuleSpec.ALWAYS_ALLOW && spec != AlwaysRuleSpec.ALWAYS_DENY) continue;
            break;
        }
        if (filteredRules.size() == 0) {
            return AlwaysRuleSpec.ALWAYS_PASS;
        }
        if (filteredRules.size() == 1) {
            return (RuleSpec)filteredRules.get(0);
        }
        return new ChainRuleSpec(filteredRules);
    }

    @Override
    public Rule build() {
        Rule[] built = (Rule[])this.rules.stream().map(RuleSpec::build).toArray(Rule[]::new);
        return (attacker, defender) -> {
            for (Rule rule : built) {
                TriState result = (TriState)((Object)((Object)rule.apply(attacker, defender)));
                if (result == TriState.DEFAULT) continue;
                return result;
            }
            return TriState.DEFAULT;
        };
    }

    @Override
    public Codec<? extends RuleSpec> codec() {
        return CODEC;
    }
}

