/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.apathy.rule.spec;

import agency.highlysuspect.apathy.Apathy;
import agency.highlysuspect.apathy.TriState;
import agency.highlysuspect.apathy.rule.Rule;
import agency.highlysuspect.apathy.rule.spec.RuleSpec;
import agency.highlysuspect.apathy.rule.spec.Specs;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;

public record DebugRuleSpec(RuleSpec rule, String message) implements RuleSpec
{
    public static final Codec<DebugRuleSpec> CODEC = RecordCodecBuilder.create(i -> i.group((App)Specs.RULE_SPEC_CODEC.fieldOf("rule").forGetter(x -> x.rule), (App)Codec.STRING.fieldOf("message").forGetter(x -> x.message)).apply((Applicative)i, DebugRuleSpec::new));

    @Override
    public RuleSpec optimize() {
        return new DebugRuleSpec(this.rule.optimize(), this.message);
    }

    @Override
    public Rule build() {
        Rule built = this.rule.build();
        return (attacker, defender) -> {
            Apathy.LOG.info("rule: " + this.message);
            TriState result = (TriState)((Object)((Object)built.apply(attacker, defender)));
            Apathy.LOG.info("returned: " + DebugRuleSpec.showTriState(result));
            return result;
        };
    }

    private static String showTriState(TriState state) {
        return switch (state) {
            default -> throw new IncompatibleClassChangeError();
            case TriState.FALSE -> "deny";
            case TriState.DEFAULT -> "pass";
            case TriState.TRUE -> "allow";
        };
    }

    @Override
    public Codec<? extends RuleSpec> codec() {
        return CODEC;
    }
}

