/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.apathy.rule.spec;

import agency.highlysuspect.apathy.TriState;
import agency.highlysuspect.apathy.rule.CodecUtil;
import agency.highlysuspect.apathy.rule.Partial;
import agency.highlysuspect.apathy.rule.Rule;
import agency.highlysuspect.apathy.rule.spec.AlwaysRuleSpec;
import agency.highlysuspect.apathy.rule.spec.RuleSpec;
import agency.highlysuspect.apathy.rule.spec.Specs;
import agency.highlysuspect.apathy.rule.spec.predicate.AlwaysPredicateSpec;
import agency.highlysuspect.apathy.rule.spec.predicate.PredicateSpec;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;

public final class PredicatedRuleSpec
implements RuleSpec {
    public static final Codec<PredicatedRuleSpec> PREDICATED_CODEC = RecordCodecBuilder.create(i -> i.group((App)CodecUtil.TRISTATE_ALLOW_DENY_PASS.optionalFieldOf("if_true", (Object)TriState.DEFAULT).forGetter(x -> x.ifTrue), (App)CodecUtil.TRISTATE_ALLOW_DENY_PASS.optionalFieldOf("if_false", (Object)TriState.DEFAULT).forGetter(x -> x.ifFalse), (App)Specs.PREDICATE_SPEC_CODEC.fieldOf("predicate").forGetter(x -> x.predSpec)).apply((Applicative)i, PredicatedRuleSpec::new));
    public static final Codec<PredicatedRuleSpec> ALLOW_IF_CODEC = RecordCodecBuilder.create(i -> i.group((App)Specs.PREDICATE_SPEC_CODEC.fieldOf("predicate").forGetter(x -> x.predSpec)).apply((Applicative)i, PredicatedRuleSpec::allowIf));
    public static final Codec<PredicatedRuleSpec> DENY_IF_CODEC = RecordCodecBuilder.create(i -> i.group((App)Specs.PREDICATE_SPEC_CODEC.fieldOf("predicate").forGetter(x -> x.predSpec)).apply((Applicative)i, PredicatedRuleSpec::denyIf));
    private final TriState ifTrue;
    private final TriState ifFalse;
    private final PredicateSpec predSpec;
    private final Codec<PredicatedRuleSpec> theCodec;

    public PredicatedRuleSpec(TriState ifTrue, TriState ifFalse, PredicateSpec predSpec) {
        this(ifTrue, ifFalse, predSpec, PREDICATED_CODEC);
    }

    public static PredicatedRuleSpec allowIf(PredicateSpec spec) {
        return new PredicatedRuleSpec(TriState.TRUE, TriState.DEFAULT, spec, ALLOW_IF_CODEC);
    }

    public static PredicatedRuleSpec denyIf(PredicateSpec spec) {
        return new PredicatedRuleSpec(TriState.FALSE, TriState.DEFAULT, spec, DENY_IF_CODEC);
    }

    public PredicatedRuleSpec(TriState ifTrue, TriState ifFalse, PredicateSpec predSpec, Codec<PredicatedRuleSpec> theCodec) {
        this.ifTrue = ifTrue;
        this.ifFalse = ifFalse;
        this.predSpec = predSpec;
        this.theCodec = theCodec;
    }

    @Override
    public RuleSpec optimize() {
        if (this.ifTrue == this.ifFalse) {
            return AlwaysRuleSpec.always(this.ifTrue);
        }
        PredicateSpec predSpecOpt = this.predSpec.optimize();
        if (this.predSpec == AlwaysPredicateSpec.TRUE) {
            return AlwaysRuleSpec.always(this.ifTrue);
        }
        if (this.predSpec == AlwaysPredicateSpec.FALSE) {
            return AlwaysRuleSpec.always(this.ifFalse);
        }
        Codec<PredicatedRuleSpec> newCodec = PREDICATED_CODEC;
        if (this.ifFalse == TriState.DEFAULT) {
            if (this.ifTrue == TriState.TRUE) {
                newCodec = ALLOW_IF_CODEC;
            }
            if (this.ifTrue == TriState.FALSE) {
                newCodec = DENY_IF_CODEC;
            }
        }
        return new PredicatedRuleSpec(this.ifTrue, this.ifFalse, predSpecOpt, newCodec);
    }

    @Override
    public Rule build() {
        Partial builtPred = this.predSpec.build();
        return (attacker, defender) -> builtPred.test(attacker, defender) ? this.ifTrue : this.ifFalse;
    }

    @Override
    public Codec<? extends RuleSpec> codec() {
        return this.theCodec;
    }

    public TriState ifTrue() {
        return this.ifTrue;
    }

    public TriState ifFalse() {
        return this.ifFalse;
    }

    public PredicateSpec predSpec() {
        return this.predSpec;
    }

    public Codec<PredicatedRuleSpec> theCodec() {
        return this.theCodec;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        PredicatedRuleSpec that = (PredicatedRuleSpec)obj;
        return Objects.equals((Object)this.ifTrue, (Object)that.ifTrue) && Objects.equals((Object)this.ifFalse, (Object)that.ifFalse) && Objects.equals(this.predSpec, that.predSpec) && Objects.equals(this.theCodec, that.theCodec);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.ifTrue, this.ifFalse, this.predSpec, this.theCodec});
    }

    public String toString() {
        return "PredicatedRuleSpec[ifTrue=" + this.ifTrue + ", ifFalse=" + this.ifFalse + ", predSpec=" + this.predSpec + ", theCodec=" + this.theCodec + "]";
    }
}

