/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.apathy.rule.spec.predicate;

import agency.highlysuspect.apathy.rule.CodecUtil;
import agency.highlysuspect.apathy.rule.Partial;
import agency.highlysuspect.apathy.rule.spec.Specs;
import agency.highlysuspect.apathy.rule.spec.predicate.AlwaysPredicateSpec;
import agency.highlysuspect.apathy.rule.spec.predicate.PredicateSpec;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import java.util.stream.Collectors;

public record AllPredicateSpec(Set<PredicateSpec> others) implements PredicateSpec
{
    public static final Codec<AllPredicateSpec> CODEC = RecordCodecBuilder.create(i -> i.group((App)CodecUtil.setOf(Specs.PREDICATE_SPEC_CODEC).fieldOf("predicates").forGetter(x -> x.others)).apply((Applicative)i, AllPredicateSpec::new));

    @Override
    public PredicateSpec optimize() {
        Set<PredicateSpec> loweredSpecs = this.others.stream().map(PredicateSpec::optimize).collect(Collectors.toSet());
        if (loweredSpecs.stream().anyMatch(pred -> pred == AlwaysPredicateSpec.FALSE)) {
            return AlwaysPredicateSpec.FALSE;
        }
        loweredSpecs.removeIf(pred -> pred == AlwaysPredicateSpec.TRUE);
        if (loweredSpecs.size() == 0) {
            return AlwaysPredicateSpec.FALSE;
        }
        if (loweredSpecs.size() == 1) {
            return (PredicateSpec)loweredSpecs.iterator().next();
        }
        return new AllPredicateSpec(loweredSpecs);
    }

    @Override
    public Partial build() {
        Partial[] arrayParts = (Partial[])this.others.stream().map(PredicateSpec::build).toArray(Partial[]::new);
        return (attacker, defender) -> {
            for (Partial p : arrayParts) {
                if (p.test(attacker, defender)) continue;
                return false;
            }
            return true;
        };
    }

    @Override
    public Codec<? extends PredicateSpec> codec() {
        return CODEC;
    }
}

