/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.apathy.rule.spec.predicate;

import agency.highlysuspect.apathy.PlayerSetManager;
import agency.highlysuspect.apathy.rule.CodecUtil;
import agency.highlysuspect.apathy.rule.Partial;
import agency.highlysuspect.apathy.rule.spec.predicate.AlwaysPredicateSpec;
import agency.highlysuspect.apathy.rule.spec.predicate.PredicateSpec;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public record DefenderInPlayerSetPredicateSpec(Set<String> playerSetNames) implements PredicateSpec
{
    public static final Codec<DefenderInPlayerSetPredicateSpec> CODEC = RecordCodecBuilder.create(i -> i.group((App)CodecUtil.setOf(Codec.STRING).fieldOf("player_sets").forGetter(x -> x.playerSetNames)).apply((Applicative)i, DefenderInPlayerSetPredicateSpec::new));

    @Override
    public PredicateSpec optimize() {
        if (this.playerSetNames.isEmpty()) {
            return AlwaysPredicateSpec.FALSE;
        }
        return this;
    }

    @Override
    public Partial build() {
        return (attacker, defender) -> {
            MinecraftServer server = defender.m_20194_();
            assert (server != null);
            PlayerSetManager setManager = PlayerSetManager.getFor(server);
            for (String playerSetName : this.playerSetNames) {
                if (!setManager.playerInSet((ServerPlayer)defender, playerSetName)) continue;
                return true;
            }
            return false;
        };
    }

    @Override
    public Codec<? extends PredicateSpec> codec() {
        return CODEC;
    }
}

