/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.apathy.core.rule;

import agency.highlysuspect.apathy.core.Apathy;
import agency.highlysuspect.apathy.core.rule.CoolGsonHelper;
import agency.highlysuspect.apathy.core.rule.JsonSerializer;
import agency.highlysuspect.apathy.core.rule.Partial;
import agency.highlysuspect.apathy.core.rule.PartialSpecAlways;
import agency.highlysuspect.apathy.core.rule.Spec;
import agency.highlysuspect.apathy.core.wrapper.Attacker;
import agency.highlysuspect.apathy.core.wrapper.AttackerTag;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public final class PartialSpecAttackerTaggedWith
implements Spec<Partial, PartialSpecAttackerTaggedWith> {
    public final Set<AttackerTag> tags;

    public PartialSpecAttackerTaggedWith(Set<AttackerTag> tags) {
        this.tags = tags;
    }

    @Override
    public Spec<Partial, ?> optimize() {
        if (this.tags.isEmpty()) {
            return PartialSpecAlways.FALSE;
        }
        return this;
    }

    @Override
    public Partial build() {
        return (attacker, defender) -> {
            for (AttackerTag tag : this.tags) {
                if (!tag.apathy$is((Attacker)attacker)) continue;
                return true;
            }
            return false;
        };
    }

    @Override
    public JsonSerializer<PartialSpecAttackerTaggedWith> getSerializer() {
        return Serializer.INSTANCE;
    }

    public static class Serializer
    implements JsonSerializer<PartialSpecAttackerTaggedWith> {
        public static final Serializer INSTANCE = new Serializer();

        private Serializer() {
        }

        @Override
        public void write(PartialSpecAttackerTaggedWith thing, JsonObject json) {
            json.add("tags", (JsonElement)thing.tags.stream().map(AttackerTag::apathy$id).map(JsonPrimitive::new).collect(CoolGsonHelper.toJsonArray()));
        }

        @Override
        public PartialSpecAttackerTaggedWith read(JsonObject json) {
            return new PartialSpecAttackerTaggedWith(StreamSupport.stream(json.getAsJsonArray("tags").spliterator(), false).map(JsonElement::getAsString).map(Apathy.instance::parseAttackerTag).collect(Collectors.toSet()));
        }
    }
}

