/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.apathy.core.rule;

import agency.highlysuspect.apathy.core.rule.CoolGsonHelper;
import agency.highlysuspect.apathy.core.rule.JsonSerializer;
import agency.highlysuspect.apathy.core.rule.Partial;
import agency.highlysuspect.apathy.core.rule.PartialSpecAlways;
import agency.highlysuspect.apathy.core.rule.Spec;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class PartialSpecSpawnType
implements Spec<Partial, PartialSpecSpawnType> {
    private final Set<String> spawnTypes;

    public PartialSpecSpawnType(Set<String> spawnTypes) {
        this.spawnTypes = spawnTypes;
    }

    @Override
    public Spec<Partial, ?> optimize() {
        if (this.spawnTypes.isEmpty()) {
            return PartialSpecAlways.FALSE;
        }
        return this;
    }

    @Override
    public Partial build() {
        Set<String> spawnTypes = this.spawnTypes.size() == 1 ? Collections.singleton(this.spawnTypes.iterator().next()) : this.spawnTypes;
        return (attacker, defender) -> {
            @Nullable String spawnType = attacker.apathy$getSpawnType();
            if (spawnType == null) {
                spawnType = "unknown";
            }
            return spawnTypes.contains(spawnType);
        };
    }

    @Override
    public JsonSerializer<PartialSpecSpawnType> getSerializer() {
        return Serializer.INSTANCE;
    }

    public static final class Serializer
    implements JsonSerializer<PartialSpecSpawnType> {
        public static final Serializer INSTANCE = new Serializer();

        @Override
        public void write(PartialSpecSpawnType thing, JsonObject json) {
            json.add("types", (JsonElement)thing.spawnTypes.stream().map(JsonPrimitive::new).collect(CoolGsonHelper.toJsonArray()));
        }

        @Override
        public PartialSpecSpawnType read(JsonObject json) {
            return new PartialSpecSpawnType(CoolGsonHelper.streamArray(json.getAsJsonArray("types")).map(JsonElement::getAsString).collect(Collectors.toSet()));
        }
    }
}

