/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.apathy.core.rule;

import agency.highlysuspect.apathy.core.Apathy;
import agency.highlysuspect.apathy.core.TriState;
import agency.highlysuspect.apathy.core.rule.JsonSerializer;
import agency.highlysuspect.apathy.core.rule.Rule;
import agency.highlysuspect.apathy.core.rule.Spec;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

public class RuleSpecDebug
implements Spec<Rule, RuleSpecDebug> {
    public final Spec<Rule, ?> rule;
    public final String message;

    public RuleSpecDebug(Spec<Rule, ?> rule, String message) {
        this.rule = rule;
        this.message = message;
    }

    @Override
    public Spec<Rule, ?> optimize() {
        return new RuleSpecDebug(this.rule.optimize(), this.message);
    }

    @Override
    public Rule build() {
        Rule built = this.rule.build();
        return (attacker, defender) -> {
            Apathy.instance.log.warn("rule: " + this.message, new Object[0]);
            TriState result = (TriState)((Object)((Object)built.apply(attacker, defender)));
            Apathy.instance.log.warn("returned: " + result.toAllowDenyPassString(), new Object[0]);
            return result;
        };
    }

    @Override
    public JsonSerializer<RuleSpecDebug> getSerializer() {
        return Serializer.INSTANCE;
    }

    public static class Serializer
    implements JsonSerializer<RuleSpecDebug> {
        public static final Serializer INSTANCE = new Serializer();

        private Serializer() {
        }

        @Override
        public void write(RuleSpecDebug thing, JsonObject json) {
            json.add("rule", (JsonElement)Apathy.instance.writeRule(thing.rule));
            json.addProperty("message", thing.message);
        }

        @Override
        public RuleSpecDebug read(JsonObject json) {
            return new RuleSpecDebug(Apathy.instance.readRule((JsonElement)json.getAsJsonObject("rule")), json.getAsJsonPrimitive("message").getAsString());
        }
    }
}

