/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.apathy.core.wrapper;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public enum ApathyDifficulty {
    PEACEFUL,
    EASY,
    NORMAL,
    HARD;


    public String toString() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public static ApathyDifficulty fromStringOrNull(String name) {
        switch (name.toLowerCase(Locale.ROOT)) {
            case "peaceful": {
                return PEACEFUL;
            }
            case "easy": {
                return EASY;
            }
            case "normal": {
                return NORMAL;
            }
            case "hard": {
                return HARD;
            }
        }
        return null;
    }

    public static ApathyDifficulty fromString(String name) {
        ApathyDifficulty x = ApathyDifficulty.fromStringOrNull(name);
        if (x == null) {
            throw new IllegalArgumentException("expected 'peaceful', 'easy', 'normal', or 'hard'");
        }
        return x;
    }

    public static Set<ApathyDifficulty> allDifficultiesNotPeaceful() {
        HashSet<ApathyDifficulty> funy = new HashSet<ApathyDifficulty>(Arrays.asList(ApathyDifficulty.values()));
        funy.remove((Object)PEACEFUL);
        return funy;
    }
}

