/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.apathy.coreplusminecraft;

import agency.highlysuspect.apathy.core.Apathy;
import agency.highlysuspect.apathy.coreplusminecraft.ApathyPlusMinecraft;
import agency.highlysuspect.apathy.coreplusminecraft.PlayerSetManagerGuts;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;

public class ApathyCommands {
    public static void registerCommands(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"apathy").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"set").then(Commands.m_82127_((String)"join").then(Commands.m_82129_((String)"set", (ArgumentType)StringArgumentType.string()).suggests(PlayerSetManagerGuts::suggestSelfSelectPlayerSets).executes(cmd -> ApathyCommands.joinSet((CommandContext<CommandSourceStack>)cmd, Collections.singletonList(((CommandSourceStack)cmd.getSource()).m_81375_()), StringArgumentType.getString((CommandContext)cmd, (String)"set"), false))))).then(Commands.m_82127_((String)"part").then(Commands.m_82129_((String)"set", (ArgumentType)StringArgumentType.string()).suggests(PlayerSetManagerGuts::suggestSelfSelectPlayerSets).executes(cmd -> ApathyCommands.partSet((CommandContext<CommandSourceStack>)cmd, Collections.singletonList(((CommandSourceStack)cmd.getSource()).m_81375_()), StringArgumentType.getString((CommandContext)cmd, (String)"set"), false))))).then(Commands.m_82127_((String)"show").executes(cmd -> ApathyCommands.personalShow((CommandContext<CommandSourceStack>)cmd, ((CommandSourceStack)cmd.getSource()).m_81375_()))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"set-admin").requires(src -> src.m_6761_(2))).then(Commands.m_82127_((String)"join").then(Commands.m_82129_((String)"who", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"set", (ArgumentType)StringArgumentType.string()).suggests(PlayerSetManagerGuts::suggestAllPlayerSets).executes(cmd -> ApathyCommands.joinSet((CommandContext<CommandSourceStack>)cmd, EntityArgument.m_91477_((CommandContext)cmd, (String)"who"), StringArgumentType.getString((CommandContext)cmd, (String)"set"), true)))))).then(Commands.m_82127_((String)"part").then(Commands.m_82129_((String)"who", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"set", (ArgumentType)StringArgumentType.string()).suggests(PlayerSetManagerGuts::suggestAllPlayerSets).executes(cmd -> ApathyCommands.partSet((CommandContext<CommandSourceStack>)cmd, EntityArgument.m_91477_((CommandContext)cmd, (String)"who"), StringArgumentType.getString((CommandContext)cmd, (String)"set"), true)))))).then(Commands.m_82127_((String)"show").executes(ApathyCommands::adminShowSets))).then(Commands.m_82127_((String)"delete").then(Commands.m_82129_((String)"set", (ArgumentType)StringArgumentType.string()).suggests(PlayerSetManagerGuts::suggestAllPlayerSets).executes(cmd -> ApathyCommands.adminDeleteSet((CommandContext<CommandSourceStack>)cmd, StringArgumentType.getString((CommandContext)cmd, (String)"set")))))).then(Commands.m_82127_((String)"create").then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.word()).then(Commands.m_82129_((String)"self-select", (ArgumentType)BoolArgumentType.bool()).executes(cmd -> ApathyCommands.adminCreateSet((CommandContext<CommandSourceStack>)cmd, StringArgumentType.getString((CommandContext)cmd, (String)"name"), BoolArgumentType.getBool((CommandContext)cmd, (String)"self-select"))))))).then(Commands.m_82127_((String)"edit").then(Commands.m_82129_((String)"set", (ArgumentType)StringArgumentType.string()).suggests(PlayerSetManagerGuts::suggestAllPlayerSets).then(Commands.m_82129_((String)"self-select", (ArgumentType)BoolArgumentType.bool()).executes(cmd -> ApathyCommands.adminEditSet((CommandContext<CommandSourceStack>)cmd, StringArgumentType.getString((CommandContext)cmd, (String)"set"), BoolArgumentType.getBool((CommandContext)cmd, (String)"self-select")))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"reload").requires(src -> src.m_6761_(2))).executes(ApathyCommands::reloadNow)));
    }

    private static void err(CommandContext<CommandSourceStack> cmd, String msg, Object ... args) {
        ((CommandSourceStack)cmd.getSource()).m_81352_(ApathyCommands.lit(msg, args));
    }

    private static void personalMsg(CommandContext<CommandSourceStack> cmd, String msg, Object ... args) {
        ApathyPlusMinecraft.instanceMinecraft.sendSuccess(cmd, () -> ApathyCommands.lit(msg, args), false);
    }

    private static void msg(CommandContext<CommandSourceStack> cmd, String msg, Object ... args) {
        ApathyPlusMinecraft.instanceMinecraft.sendSuccess(cmd, () -> ApathyCommands.lit(msg, args), true);
    }

    private static Component lit(String msg, Object ... args) {
        for (int i = 0; i < args.length; ++i) {
            if (!(args[i] instanceof Component)) continue;
            args[i] = ApathyPlusMinecraft.instanceMinecraft.stringifyComponent((Component)args[i]);
        }
        return ApathyPlusMinecraft.instanceMinecraft.literal(String.format(msg, args));
    }

    private static int joinSet(CommandContext<CommandSourceStack> cmd, Collection<ServerPlayer> players, String name, boolean op) {
        int successCount = 0;
        for (ServerPlayer player : players) {
            PlayerSetManagerGuts.JoinResult result = ApathyPlusMinecraft.instanceMinecraft.getFor(cmd).join(player, name, op);
            switch (result) {
                case SUCCESS: {
                    ++successCount;
                    ApathyCommands.msg(cmd, "%s joined set %s.", player.m_7755_(), name);
                    break;
                }
                case NO_SUCH_SET: {
                    ApathyCommands.err(cmd, "There isn't a set named %s. Try /apathy set-admin create.", name);
                    break;
                }
                case ALREADY_IN_SET: {
                    ApathyCommands.err(cmd, "Player %s is already in set %s. Try /apathy set part.", player.m_7755_(), name);
                    break;
                }
                case NOT_SELF_SELECT: {
                    ApathyCommands.err(cmd, "Set %s is not a self-select set. Try /apathy set-admin join.", name);
                }
            }
        }
        return successCount;
    }

    private static int partSet(CommandContext<CommandSourceStack> cmd, Collection<ServerPlayer> players, String name, boolean op) {
        int successCount = 0;
        for (ServerPlayer player : players) {
            PlayerSetManagerGuts.PartResult result = ApathyPlusMinecraft.instanceMinecraft.getFor(cmd).part(player, name, op);
            switch (result) {
                case SUCCESS: {
                    ++successCount;
                    ApathyCommands.msg(cmd, "%s parted set %s.", ApathyPlusMinecraft.instanceMinecraft.stringifyComponent(player.m_7755_()), name);
                    break;
                }
                case NO_SUCH_SET: {
                    ApathyCommands.err(cmd, "There isn't a set named %s. Try /apathy set-admin create.", name);
                    break;
                }
                case ALREADY_NOT_IN_SET: {
                    ApathyCommands.err(cmd, "Player %s is already not in set %s. Try /apathy set join.", player.m_7755_(), name);
                    break;
                }
                case NOT_SELF_SELECT: {
                    ApathyCommands.err(cmd, "Set %s is not a self-select set. Try /apathy set-admin part.", name);
                }
            }
        }
        return successCount;
    }

    private static int personalShow(CommandContext<CommandSourceStack> cmd, ServerPlayer player) {
        PlayerSetManagerGuts setManager = ApathyPlusMinecraft.instanceMinecraft.getFor(cmd);
        if (setManager.isEmpty()) {
            ApathyCommands.err(cmd, "There aren't any player sets.", new Object[0]);
        } else {
            ApathyCommands.personalMsg(cmd, "The following sets exist: %s", setManager.printAllPlayerSets());
        }
        for (Map.Entry<String, PlayerSetManagerGuts.Entry> entry : setManager.entrySet()) {
            if (setManager.playerInSet(player, entry.getKey())) {
                ApathyCommands.personalMsg(cmd, "You are in set %s.", entry.getKey());
                continue;
            }
            ApathyCommands.err(cmd, "You are not in set %s.", entry.getKey());
        }
        return 0;
    }

    private static int adminShowSets(CommandContext<CommandSourceStack> cmd) {
        PlayerSetManagerGuts setManager = ApathyPlusMinecraft.instanceMinecraft.getFor(cmd);
        if (setManager.isEmpty()) {
            ApathyCommands.err(cmd, "There aren't any player sets.", new Object[0]);
        } else {
            ApathyCommands.personalMsg(cmd, "The following player sets exist: %s", setManager.printAllPlayerSets());
            PlayerList mgr = ((CommandSourceStack)cmd.getSource()).m_81377_().m_6846_();
            for (Map.Entry<String, PlayerSetManagerGuts.Entry> entry : setManager.entrySet()) {
                String name = entry.getKey();
                PlayerSetManagerGuts.Entry set = entry.getValue();
                ApathyCommands.personalMsg(cmd, "Set %s contains %s members.", name, set.members().size());
                for (UUID uuid : set.members()) {
                    ServerPlayer player = mgr.m_11259_(uuid);
                    ApathyCommands.personalMsg(cmd, player == null ? String.format(" - someone with UUID %s", uuid) : String.format(" - %s (UUID %s)", ApathyPlusMinecraft.instanceMinecraft.stringifyComponent(player.m_7755_()), uuid), new Object[0]);
                }
            }
        }
        return 0;
    }

    private static int adminEditSet(CommandContext<CommandSourceStack> cmd, String name, boolean selfSelect) {
        PlayerSetManagerGuts setManager = ApathyPlusMinecraft.instanceMinecraft.getFor(cmd);
        PlayerSetManagerGuts.EditResult result = setManager.edit(name, selfSelect);
        switch (result) {
            case SUCCESS: {
                ApathyCommands.msg(cmd, selfSelect ? "Made set %s a self-select set." : "Made set %s a non-self-select set.", name);
                break;
            }
            case NO_SUCH_SET: {
                ApathyCommands.err(cmd, "There isn't a set named %s. Try /apathy set-admin create.", name);
                break;
            }
            case ALREADY_SELF_SELECT: {
                ApathyCommands.err(cmd, "Set %s is already self-select.", name);
                break;
            }
            case ALREADY_NOT_SELF_SELECT: {
                ApathyCommands.err(cmd, "Set %s is already not self-select.", name);
            }
        }
        return result == PlayerSetManagerGuts.EditResult.SUCCESS ? 1 : 0;
    }

    private static int adminCreateSet(CommandContext<CommandSourceStack> cmd, String name, boolean selfSelect) {
        PlayerSetManagerGuts setManager = ApathyPlusMinecraft.instanceMinecraft.getFor(cmd);
        PlayerSetManagerGuts.CreateResult result = setManager.create(name, selfSelect);
        switch (result) {
            case SUCCESS: {
                ApathyCommands.msg(cmd, selfSelect ? "Created self-select set %s." : "Created non-self-select set %s.", name);
                break;
            }
            case ALREADY_EXISTS: {
                ApathyCommands.err(cmd, "There's already a set named %s. Try /apathy set-admin edit.", name);
            }
        }
        return result == PlayerSetManagerGuts.CreateResult.SUCCESS ? 1 : 0;
    }

    private static int adminDeleteSet(CommandContext<CommandSourceStack> cmd, String name) {
        PlayerSetManagerGuts setManager = ApathyPlusMinecraft.instanceMinecraft.getFor(cmd);
        PlayerSetManagerGuts.DeleteResult result = setManager.delete(name);
        switch (result) {
            case SUCCESS: {
                ApathyCommands.msg(cmd, "Player set %s deleted.", name);
                break;
            }
            case NO_SUCH_SET: {
                ApathyCommands.err(cmd, "There isn't a set named %s.", name);
            }
        }
        return result == PlayerSetManagerGuts.DeleteResult.SUCCESS ? 1 : 0;
    }

    private static int reloadNow(CommandContext<CommandSourceStack> cmd) {
        boolean ok = Apathy.instance.refreshConfig();
        if (ok) {
            ApathyCommands.msg(cmd, "Reloaded Apathy config files.", new Object[0]);
        } else {
            ApathyCommands.err(cmd, "Error reloading Apathy config files. Check the server log.", new Object[0]);
        }
        return 0;
    }
}

